<?php
defined('BASEPATH') OR exit('No direct script access allowed');
// los Router son las rutas que vamos a colocar en el navegador para acceder a las funcionalidades
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/

$route['default_controller'] = 'welcome'; // ruta inicio 
// Definimos las rutas para cambiar la contraseña
$route['ChangePassword'] = 'ChangePasswordCtrl/index';

// definiremos las rutas la tabla Usuarios

$route['User'] = 'UserCtrl/index';// En esta ruta vamos a usar los metodos Get/post/delete/put 
// si se usa el metodo get se resuelve con todos los registros de la tabla usuarios

// El resto de las rutas usuarios solo aceptaran el metodo get y seran usadas para buscar informacion 

// cuando veamos (:num) signigica que estamos validando una entrada de solo numeros
// cuando veamos (:any) significa que estamos aceptando cualquier caracter
// cuando veamos $1,$2,$3...$6 significa que vamos a recibir valores en ese orden esto se recibira en forma de array()

$route['User/(:num)'] = 'UserCtrl/index/$1'; // Aqui recibimos solo un valor el id del usuarios http//:codeignier/user/id 

$route['User/(:num)/(:num)'] = 'UserCtrl/index/$1/$2'; // $1 cantidad, $2 la posicion
$route['User/(:num)/(:num)/(:num)/(:num)'] = 'UserCtrl/index/$1/$2/$3/$4'; // $1 cantidad $2 posicion $3 Columna $4 orden  

$route['User/(:num)/(:num)/(:any)/(:num)'] = 'UserCtrl/index/$1/$2/$3/$4'; // ase lo mismo que la anterior pero puedo especificar el campo a ordenar

$route['User/(:num)/(:num)/(:num)/(:num)/(:any)'] = 'UserCtrl/index/$1/$2/$3/$4/$5'; // lo mismo pero se indica las tablas s0|1|2|3..etc

$route['User/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'UserCtrl/index/$1/$2/$3/$4/$5';  // me hace lo mismo pero asignando el nombre del campo a ordenar
$route['User/(:any)'] = 'UserCtrl/Buscar1/$1';                                // filtrar s1^pedro|2^primera 
$route['User/(:any)/(:num)/(:num)'] = 'UserCtrl/Buscar1/$1/$2/$3';            // filtrar y extraer una porcion 
$route['User/(:any)/(:num)/(:num)/(:num)/(:num)'] = 'UserCtrl/Buscar1/$1/$2/$3/$4/$5';  // filtrar y extraer porcion ordenada 
$route['User/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'UserCtrl/Buscar1/$1/$2/$3/$4/$5';
$route['User/(:any)/(:num)/(:num)/(:num)/(:num)/(:any)'] = 'UserCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; // filtrar, extraer porcion ordenadas, columna
$route['User/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'UserCtrl/Buscar1/$1/$2/$3/$4/$5/$6';
$route['User/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'UserCtrl/Buscar1/$1/$2/$3/$4/$5/$6';
$route['User/(:num)/(:any)'] = 'UserCtrl/Buscar3/$1/$2';                     // rigistro por id y selecciona algunas columnas
$route['User/(:any)/(:any)'] = 'UserCtrl/Buscar2/$1/$2';                     // filtrar y seleciona columnas
$route['User/(:num)/(:num)/(:any)'] = 'UserCtrl/Buscar4/$1/$2/$3';          // porcion seleccionando columnas
$route['User/(:any)/(:num)/(:num)/(:any)'] = 'UserCtrl/Buscar5/$1/$2/$3/$4';// filtra luego saca una porcion y selecciona las columnas
// aqui establesco la ruta para crear mis pdf
$route['UserPdf'] = 'UserCtrl/Pdf';
$route['UserExcel'] = 'UserCtrl/ExportExcel';
$route['UserMeta'] = 'UserCtrl/MetaData';

// Rutas loguin
$route['Login'] = 'LoginCtrl/index';
// Rutas para gestionar la manguera hidraulica
$route['HydraulicHose'] = 'HydraulicHoseCtrl/index';                                            
$route['HydraulicHose/(:num)'] = 'HydraulicHoseCtrl/index/$1';                                  
$route['HydraulicHose/(:num)/(:num)'] = 'HydraulicHoseCtrl/index/$1/$2';                        
$route['HydraulicHose/(:num)/(:num)/(:num)/(:num)'] = 'HydraulicHoseCtrl/index/$1/$2/$3/$4';
$route['HydraulicHose/(:num)/(:num)/(:any)/(:num)'] = 'HydraulicHoseCtrl/index/$1/$2/$3/$4';     
$route['HydraulicHose/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'HydraulicHoseCtrl/index/$1/$2/$3/$4/$5';
$route['HydraulicHose/(:any)'] = 'HydraulicHoseCtrl/Buscar1/$1';                                
$route['HydraulicHose/(:any)/(:num)/(:num)'] = 'HydraulicHoseCtrl/Buscar1/$1/$2/$3';             
$route['HydraulicHose/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'HydraulicHoseCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['HydraulicHose/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'HydraulicHoseCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['HydraulicHose/(:num)/(:any)'] = 'HydraulicHoseCtrl/Buscar3/$1/$2';                     
$route['HydraulicHose/(:any)/(:any)'] = 'HydraulicHoseCtrl/Buscar2/$1/$2';                     
$route['HydraulicHose/(:num)/(:num)/(:any)'] = 'HydraulicHoseCtrl/Buscar4/$1/$2/$3';          
$route['HydraulicHose/(:any)/(:num)/(:num)/(:any)'] = 'HydraulicHoseCtrl/Buscar5/$1/$2/$3/$4';
$route['HydraulicHoseMeta'] = 'HydraulicHoseCtrl/MetaData';
$route['HydraulicHosePdf'] = 'HydraulicHoseCtrl/Pdf';
// Rutas Clientes
$route['Client'] = 'ClientCtrl/index';                                            
$route['Client/(:num)'] = 'ClientCtrl/index/$1';                                  
$route['Client/(:num)/(:num)'] = 'ClientCtrl/index/$1/$2';                        
$route['Client/(:num)/(:num)/(:num)/(:num)'] = 'ClientCtrl/index/$1/$2/$3/$4';
$route['Client/(:num)/(:num)/(:any)/(:num)'] = 'ClientCtrl/index/$1/$2/$3/$4';     
$route['Client/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ClientCtrl/index/$1/$2/$3/$4/$5';
$route['Client/(:any)'] = 'ClientCtrl/Buscar1/$1';                                
$route['Client/(:any)/(:num)/(:num)'] = 'ClientCtrl/Buscar1/$1/$2/$3';             
$route['Client/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ClientCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Client/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ClientCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Client/(:num)/(:any)'] = 'ClientCtrl/Buscar3/$1/$2';                     
$route['Client/(:any)/(:any)'] = 'ClientCtrl/Buscar2/$1/$2';                     
$route['Client/(:num)/(:num)/(:any)'] = 'ClientCtrl/Buscar4/$1/$2/$3';          
$route['Client/(:any)/(:num)/(:num)/(:any)'] = 'ClientCtrl/Buscar5/$1/$2/$3/$4';
$route['ClientMeta'] = 'ClientCtrl/MetaData';
$route['ClientPdf'] = 'ClientCtrl/Pdf';
// Ruta Nivel Esta ruta gestiona todos los niveles 
$route['Level'] = 'LevelCtrl/index';                                            
$route['Level/(:num)'] = 'LevelCtrl/index/$1';                                  
$route['Level/(:num)/(:num)'] = 'LevelCtrl/index/$1/$2';                        
$route['Level/(:num)/(:num)/(:num)/(:num)'] = 'LevelCtrl/index/$1/$2/$3/$4';
$route['Level/(:num)/(:num)/(:any)/(:num)'] = 'LevelCtrl/index/$1/$2/$3/$4';     
$route['Level/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'LevelCtrl/index/$1/$2/$3/$4/$5';
$route['Level/(:any)'] = 'LevelCtrl/Buscar1/$1';                                
$route['Level/(:any)/(:num)/(:num)'] = 'LevelCtrl/Buscar1/$1/$2/$3';             
$route['Level/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'LevelCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Level/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'LevelCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Level/(:num)/(:any)'] = 'LevelCtrl/Buscar3/$1/$2';                     
$route['Level/(:any)/(:any)'] = 'LevelCtrl/Buscar2/$1/$2';                     
$route['Level/(:num)/(:num)/(:any)'] = 'LevelCtrl/Buscar4/$1/$2/$3';          
$route['Level/(:any)/(:num)/(:num)/(:any)'] = 'LevelCtrl/Buscar5/$1/$2/$3/$4';
$route['LevelMeta'] = 'LevelCtrl/MetaData';
$route['LevelPdf'] = 'LevelCtrl/Pdf';
// rutas Store
$route['Store'] = 'StoreCtrl/index';                                            
$route['Store/(:num)'] = 'StoreCtrl/index/$1';                                  
$route['Store/(:num)/(:num)'] = 'StoreCtrl/index/$1/$2';                        
$route['Store/(:num)/(:num)/(:any)/(:num)'] = 'StoreCtrl/index/$1/$2/$3/$4';     
$route['Store/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'StoreCtrl/index/$1/$2/$3/$4/$5';
$route['Store/(:any)'] = 'StoreCtrl/Buscar1/$1';                                
$route['Store/(:any)/(:num)/(:num)'] = 'StoreCtrl/Buscar1/$1/$2/$3';             
$route['Store/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'StoreCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Store/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'StoreCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Store/(:num)/(:any)'] = 'StoreCtrl/Buscar3/$1/$2';                     
$route['Store/(:any)/(:any)'] = 'StoreCtrl/Buscar2/$1/$2';                     
$route['Store/(:num)/(:num)/(:any)'] = 'StoreCtrl/Buscar4/$1/$2/$3';          
$route['Store/(:any)/(:num)/(:num)/(:any)'] = 'StoreCtrl/Buscar5/$1/$2/$3/$4';
$route['StoreMeta'] = 'StoreCtrl/MetaData';
$route['StorePdf'] = 'StoreCtrl/Pdf';
// aqui Vamos a hacer la ruta de los Proveedores

$route['Provider'] = 'ProviderCtrl/index';                                            
$route['Provider/(:num)'] = 'ProviderCtrl/index/$1';                                  
$route['Provider/(:num)/(:num)'] = 'ProviderCtrl/index/$1/$2';                        
$route['Provider/(:num)/(:num)/(:any)/(:num)'] = 'ProviderCtrl/index/$1/$2/$3/$4';     
$route['Provider/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ProviderCtrl/index/$1/$2/$3/$4/$5';
$route['Provider/(:any)'] = 'ProviderCtrl/Buscar1/$1';                                
$route['Provider/(:any)/(:num)/(:num)'] = 'ProviderCtrl/Buscar1/$1/$2/$3';             
$route['Provider/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ProviderCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Provider/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ProviderCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Provider/(:num)/(:any)'] = 'ProviderCtrl/Buscar3/$1/$2';                     
$route['Provider/(:any)/(:any)'] = 'ProviderCtrl/Buscar2/$1/$2';                     
$route['Provider/(:num)/(:num)/(:any)'] = 'ProviderCtrl/Buscar4/$1/$2/$3';          
$route['Provider/(:any)/(:num)/(:num)/(:any)'] = 'ProviderCtrl/Buscar5/$1/$2/$3/$4';
$route['ProviderMeta'] = 'ProviderCtrl/MetaData';
$route['ProviderPdf'] = 'ProviderCtrl/Pdf';
// Ruta Productos 
$route['Product'] = 'ProductCtrl/index';                                            
$route['Product/(:num)'] = 'ProductCtrl/index/$1';                                  
$route['Product/(:num)/(:num)'] = 'ProductCtrl/index/$1/$2';                        
$route['Product/(:num)/(:num)/(:any)/(:num)'] = 'ProductCtrl/index/$1/$2/$3/$4';     
$route['Product/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ProductCtrl/index/$1/$2/$3/$4/$5';
$route['Product/(:any)'] = 'ProductCtrl/Buscar1/$1';                                
$route['Product/(:any)/(:num)/(:num)'] = 'ProductCtrl/Buscar1/$1/$2/$3';             
$route['Product/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ProductCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Product/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ProductCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Product/(:num)/(:any)'] = 'ProductCtrl/Buscar3/$1/$2';                     
$route['Product/(:any)/(:any)'] = 'ProductCtrl/Buscar2/$1/$2';                     
$route['Product/(:num)/(:num)/(:any)'] = 'ProductCtrl/Buscar4/$1/$2/$3';          
$route['Product/(:any)/(:num)/(:num)/(:any)'] = 'ProductCtrl/Buscar5/$1/$2/$3/$4';
$route['ProductMeta'] = 'ProductCtrl/MetaData';
$route['ProductPdf'] = 'ProductCtrl/Pdf';
// Ruta Clasificacion de los productos Classification
$route['Classification'] = 'ClassificationCtrl/index';                                            
$route['Classification/(:num)'] = 'ClassificationCtrl/index/$1';                                  
$route['Classification/(:num)/(:num)'] = 'ClassificationCtrl/index/$1/$2';                        
$route['Classification/(:num)/(:num)/(:any)/(:num)'] = 'ClassificationCtrl/index/$1/$2/$3/$4';     
$route['Classification/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ClassificationCtrl/index/$1/$2/$3/$4/$5';
$route['Classification/(:any)'] = 'ClassificationCtrl/Buscar1/$1';                                
$route['Classification/(:any)/(:num)/(:num)'] = 'ClassificationCtrl/Buscar1/$1/$2/$3';             
$route['Classification/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ClassificationCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Classification/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ClassificationCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Classification/(:num)/(:any)'] = 'ClassificationCtrl/Buscar3/$1/$2';                     
$route['Classification/(:any)/(:any)'] = 'ClassificationCtrl/Buscar2/$1/$2';                     
$route['Classification/(:num)/(:num)/(:any)'] = 'ClassificationCtrl/Buscar4/$1/$2/$3';          
$route['Classification/(:any)/(:num)/(:num)/(:any)'] = 'ClassificationCtrl/Buscar5/$1/$2/$3/$4';
$route['ClassificationMeta'] = 'ClassificationCtrl/MetaData';
// Rutas para asignar productos a una tienda..assignment
$route['Assignment'] = 'AssignmentCtrl/index';                                            
$route['Assignment/(:num)'] = 'AssignmentCtrl/index/$1';                                  
$route['Assignment/(:num)/(:num)'] = 'AssignmentCtrl/index/$1/$2';                        
$route['Assignment/(:num)/(:num)/(:any)/(:num)'] = 'AssignmentCtrl/index/$1/$2/$3/$4';     
$route['Assignment/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'AssignmentCtrl/index/$1/$2/$3/$4/$5';
$route['Assignment/(:any)'] = 'AssignmentCtrl/Buscar1/$1';                                
$route['Assignment/(:any)/(:num)/(:num)'] = 'AssignmentCtrl/Buscar1/$1/$2/$3';             
$route['Assignment/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'AssignmentCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Assignment/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'AssignmentCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Assignment/(:num)/(:any)'] = 'AssignmentCtrl/Buscar3/$1/$2';                     
$route['Assignment/(:any)/(:any)'] = 'AssignmentCtrl/Buscar2/$1/$2';                     
$route['Assignment/(:num)/(:num)/(:any)'] = 'AssignmentCtrl/Buscar4/$1/$2/$3';          
$route['Assignment/(:any)/(:num)/(:num)/(:any)'] = 'AssignmentCtrl/Buscar5/$1/$2/$3/$4';
$route['AssignmentMeta'] = 'AssignmentCtrl/MetaData';
// Aqui Vamos a hacer la ruta de reportes de los productos asignados
$route['ReportAssignment'] = 'ReportAssignmentCtrl/index';                                            
$route['ReportAssignment/(:num)'] = 'ReportAssignmentCtrl/index/$1';                                  
$route['ReportAssignment/(:num)/(:num)'] = 'ReportAssignmentCtrl/index/$1/$2';                        
$route['ReportAssignment/(:num)/(:num)/(:any)/(:num)'] = 'ReportAssignmentCtrl/index/$1/$2/$3/$4';     
$route['ReportAssignment/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportAssignmentCtrl/index/$1/$2/$3/$4/$5';
$route['ReportAssignment/(:any)'] = 'ReportAssignmentCtrl/Buscar1/$1';                                
$route['ReportAssignment/(:any)/(:num)/(:num)'] = 'ReportAssignmentCtrl/Buscar1/$1/$2/$3';             
$route['ReportAssignment/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReportAssignmentCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReportAssignment/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportAssignmentCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReportAssignment/(:num)/(:any)'] = 'ReportAssignmentCtrl/Buscar3/$1/$2';                     
$route['ReportAssignment/(:any)/(:any)'] = 'ReportAssignmentCtrl/Buscar2/$1/$2';                     
$route['ReportAssignment/(:num)/(:num)/(:any)'] = 'ReportAssignmentCtrl/Buscar4/$1/$2/$3';          
$route['ReportAssignment/(:any)/(:num)/(:num)/(:any)'] = 'ReportAssignmentCtrl/Buscar5/$1/$2/$3/$4';

//Reporte de productos no asignados a una tienda ReportNoAssig
$route['ReportNoAssig'] = 'ReportNoAssigCtrl/index';                                            
$route['ReportNoAssig/(:num)'] = 'ReportNoAssigCtrl/index/$1';                                  
$route['ReportNoAssig/(:num)/(:num)'] = 'ReportNoAssigCtrl/index/$1/$2';                        
$route['ReportNoAssig/(:num)/(:num)/(:any)/(:num)'] = 'ReportNoAssigCtrl/index/$1/$2/$3/$4';     
$route['ReportNoAssig/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportNoAssigCtrl/index/$1/$2/$3/$4/$5';
$route['ReportNoAssig/(:any)'] = 'ReportNoAssigCtrl/Buscar1/$1';                                
$route['ReportNoAssig/(:any)/(:num)/(:num)'] = 'ReportNoAssigCtrl/Buscar1/$1/$2/$3';             
$route['ReportNoAssig/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReportNoAssigCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReportNoAssig/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportNoAssigCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReportNoAssig/(:num)/(:any)'] = 'ReportNoAssigCtrl/Buscar3/$1/$2';                     
$route['ReportNoAssig/(:any)/(:any)'] = 'ReportNoAssigCtrl/Buscar2/$1/$2';                     
$route['ReportNoAssig/(:num)/(:num)/(:any)'] = 'ReportNoAssigCtrl/Buscar4/$1/$2/$3';          
$route['ReportNoAssig/(:any)/(:num)/(:num)/(:any)'] = 'ReportNoAssigCtrl/Buscar5/$1/$2/$3/$4';
// Reporte inicial de almacen me va a mostrar la existencia segun su stop ReporWarehouse
$route['ReporWarehouse'] = 'ReporWarehouseCtrl/index';                                            
$route['ReporWarehouse/(:num)'] = 'ReporWarehouseCtrl/index/$1';                                  
$route['ReporWarehouse/(:num)/(:num)'] = 'ReporWarehouseCtrl/index/$1/$2';                        
$route['ReporWarehouse/(:num)/(:num)/(:any)/(:num)'] = 'ReporWarehouseCtrl/index/$1/$2/$3/$4';     
$route['ReporWarehouse/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporWarehouseCtrl/index/$1/$2/$3/$4/$5';
$route['ReporWarehouse/(:any)'] = 'ReporWarehouseCtrl/Buscar1/$1';                                
$route['ReporWarehouse/(:any)/(:num)/(:num)'] = 'ReporWarehouseCtrl/Buscar1/$1/$2/$3';             
$route['ReporWarehouse/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporWarehouseCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporWarehouse/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporWarehouseCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporWarehouse/(:num)/(:any)'] = 'ReporWarehouseCtrl/Buscar3/$1/$2';                     
$route['ReporWarehouse/(:any)/(:any)'] = 'ReporWarehouseCtrl/Buscar2/$1/$2';                     
$route['ReporWarehouse/(:num)/(:num)/(:any)'] = 'ReporWarehouseCtrl/Buscar4/$1/$2/$3';          
$route['ReporWarehouse/(:any)/(:num)/(:num)/(:any)'] = 'ReporWarehouseCtrl/Buscar5/$1/$2/$3/$4';
$route['ReporWarehouseMeta'] = 'ReporWarehouseCtrl/MetaData';
// aqui vamos a procesar el almacen Warehouse
$route['Warehouse'] = 'WarehouseCtrl/index';                                            
$route['Warehouse/(:num)'] = 'WarehouseCtrl/index/$1';                                  
$route['Warehouse/(:num)/(:num)'] = 'WarehouseCtrl/index/$1/$2';                        
$route['Warehouse/(:num)/(:num)/(:any)/(:num)'] = 'WarehouseCtrl/index/$1/$2/$3/$4';     
$route['Warehouse/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'WarehouseCtrl/index/$1/$2/$3/$4/$5';
$route['Warehouse/(:any)'] = 'WarehouseCtrl/Buscar1/$1';                                
$route['Warehouse/(:any)/(:num)/(:num)'] = 'WarehouseCtrl/Buscar1/$1/$2/$3';             
$route['Warehouse/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'WarehouseCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Warehouse/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'WarehouseCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Warehouse/(:num)/(:any)'] = 'WarehouseCtrl/Buscar3/$1/$2';                     
$route['Warehouse/(:any)/(:any)'] = 'WarehouseCtrl/Buscar2/$1/$2';                     
$route['Warehouse/(:num)/(:num)/(:any)'] = 'WarehouseCtrl/Buscar4/$1/$2/$3';          
$route['Warehouse/(:any)/(:num)/(:num)/(:any)'] = 'WarehouseCtrl/Buscar5/$1/$2/$3/$4';
//  Lista detallada de los movimeintos de entrada de almacen 
$route['ReporWareDetalle'] = 'ReporWareDetalleCtrl/index';                                            
$route['ReporWareDetalle/(:num)'] = 'ReporWareDetalleCtrl/index/$1';                                  
$route['ReporWareDetalle/(:num)/(:num)'] = 'ReporWareDetalleCtrl/index/$1/$2';                        
$route['ReporWareDetalle/(:num)/(:num)/(:any)/(:num)'] = 'ReporWareDetalleCtrl/index/$1/$2/$3/$4';     
$route['ReporWareDetalle/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporWareDetalleCtrl/index/$1/$2/$3/$4/$5';
$route['ReporWareDetalle/(:any)'] = 'ReporWareDetalleCtrl/Buscar1/$1';                                
$route['ReporWareDetalle/(:any)/(:num)/(:num)'] = 'ReporWareDetalleCtrl/Buscar1/$1/$2/$3';             
$route['ReporWareDetalle/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporWareDetalleCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporWareDetalle/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporWareDetalleCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporWareDetalle/(:num)/(:any)'] = 'ReporWareDetalleCtrl/Buscar3/$1/$2';                     
$route['ReporWareDetalle/(:any)/(:any)'] = 'ReporWareDetalleCtrl/Buscar2/$1/$2';                     
$route['ReporWareDetalle/(:num)/(:num)/(:any)'] = 'ReporWareDetalleCtrl/Buscar4/$1/$2/$3';          
$route['ReporWareDetalle/(:any)/(:num)/(:num)/(:any)'] = 'ReporWareDetalleCtrl/Buscar5/$1/$2/$3/$4';
// Ruta gestion de navios o naves
$route['Ship'] = 'ShipCtrl/index'; // ruta general Get,post,put,                                            
$route['Ship/(:num)'] = 'ShipCtrl/index/$1';                                  
$route['Ship/(:num)/(:num)'] = 'ShipCtrl/index/$1/$2';                        
$route['Ship/(:num)/(:num)/(:num)/(:num)'] = 'ShipCtrl/index/$1/$2/$3/$4';
$route['Ship/(:num)/(:num)/(:any)/(:num)'] = 'ShipCtrl/index/$1/$2/$3/$4';     
$route['Ship/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ShipCtrl/index/$1/$2/$3/$4/$5';
$route['Ship/(:any)'] = 'ShipCtrl/Buscar1/$1';                                
$route['Ship/(:any)/(:num)/(:num)'] = 'ShipCtrl/Buscar1/$1/$2/$3';             
$route['Ship/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ShipCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Ship/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ShipCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Ship/(:num)/(:any)'] = 'ShipCtrl/Buscar3/$1/$2';                     
$route['Ship/(:any)/(:any)'] = 'ShipCtrl/Buscar2/$1/$2';                     
$route['Ship/(:num)/(:num)/(:any)'] = 'ShipCtrl/Buscar4/$1/$2/$3';          
$route['Ship/(:any)/(:num)/(:num)/(:any)'] = 'ShipCtrl/Buscar5/$1/$2/$3/$4';
$route['ShipMeta'] = 'ShipCtrl/MetaData';
// ruta de registro de balsas
$route['Raft'] = 'RaftCtrl/index'; // ruta general Get,post,put,                                            
$route['Raft/(:num)'] = 'RaftCtrl/index/$1';                                  
$route['Raft/(:num)/(:num)'] = 'RaftCtrl/index/$1/$2';                        
$route['Raft/(:num)/(:num)/(:num)/(:num)'] = 'RaftCtrl/index/$1/$2/$3/$4';
$route['Raft/(:num)/(:num)/(:any)/(:num)'] = 'RaftCtrl/index/$1/$2/$3/$4';     
$route['Raft/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'RaftCtrl/index/$1/$2/$3/$4/$5';
$route['Raft/(:any)'] = 'RaftCtrl/Buscar1/$1';                                
$route['Raft/(:any)/(:num)/(:num)'] = 'RaftCtrl/Buscar1/$1/$2/$3';             
$route['Raft/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'RaftCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Raft/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'RaftCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Raft/(:num)/(:any)'] = 'RaftCtrl/Buscar3/$1/$2';                     
$route['Raft/(:any)/(:any)'] = 'RaftCtrl/Buscar2/$1/$2';                     
$route['Raft/(:num)/(:num)/(:any)'] = 'RaftCtrl/Buscar4/$1/$2/$3';          
$route['Raft/(:any)/(:num)/(:num)/(:any)'] = 'RaftCtrl/Buscar5/$1/$2/$3/$4';
$route['RaftMeta'] = 'RaftCtrl/MetaData';
// Rutas de registro y consulta de Valvulas
$route['Valve'] = 'ValveCtrl/index'; // ruta general Get,post,put,                                            
$route['Valve/(:num)'] = 'ValveCtrl/index/$1';                                  
$route['Valve/(:num)/(:num)'] = 'ValveCtrl/index/$1/$2';                        
$route['Valve/(:num)/(:num)/(:num)/(:num)'] = 'ValveCtrl/index/$1/$2/$3/$4';
$route['Valve/(:num)/(:num)/(:any)/(:num)'] = 'ValveCtrl/index/$1/$2/$3/$4';     
$route['Valve/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ValveCtrl/index/$1/$2/$3/$4/$5';
$route['Valve/(:any)'] = 'ValveCtrl/Buscar1/$1';                                
$route['Valve/(:any)/(:num)/(:num)'] = 'ValveCtrl/Buscar1/$1/$2/$3';             
$route['Valve/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ValveCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Valve/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ValveCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Valve/(:num)/(:any)'] = 'ValveCtrl/Buscar3/$1/$2';                     
$route['Valve/(:any)/(:any)'] = 'ValveCtrl/Buscar2/$1/$2';                     
$route['Valve/(:num)/(:num)/(:any)'] = 'ValveCtrl/Buscar4/$1/$2/$3';          
$route['Valve/(:any)/(:num)/(:num)/(:any)'] = 'ValveCtrl/Buscar5/$1/$2/$3/$4';
$route['ValveMeta'] = 'ValveCtrl/MetaData';
// Rutas de registro de Cilindros de inflado
$route['Cylinder'] = 'CylinderCtrl/index'; // ruta general Get,post,put,                                            
$route['Cylinder/(:num)'] = 'CylinderCtrl/index/$1';                                  
$route['Cylinder/(:num)/(:num)'] = 'CylinderCtrl/index/$1/$2';                        
$route['Cylinder/(:num)/(:num)/(:num)/(:num)'] = 'CylinderCtrl/index/$1/$2/$3/$4';
$route['Cylinder/(:num)/(:num)/(:any)/(:num)'] = 'CylinderCtrl/index/$1/$2/$3/$4';     
$route['Cylinder/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'CylinderCtrl/index/$1/$2/$3/$4/$5';
$route['Cylinder/(:any)'] = 'CylinderCtrl/Buscar1/$1';                                
$route['Cylinder/(:any)/(:num)/(:num)'] = 'CylinderCtrl/Buscar1/$1/$2/$3';             
$route['Cylinder/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'CylinderCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Cylinder/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'CylinderCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Cylinder/(:num)/(:any)'] = 'CylinderCtrl/Buscar3/$1/$2';                     
$route['Cylinder/(:any)/(:any)'] = 'CylinderCtrl/Buscar2/$1/$2';                     
$route['Cylinder/(:num)/(:num)/(:any)'] = 'CylinderCtrl/Buscar4/$1/$2/$3';          
$route['Cylinder/(:any)/(:num)/(:num)/(:any)'] = 'CylinderCtrl/Buscar5/$1/$2/$3/$4';
$route['CylinderMeta'] = 'CylinderCtrl/MetaData';
// Rutas para gestionar las Ordenes de Trabajo Order
$route['Order'] = 'OrderCtrl/index';                                             
$route['Order/(:num)'] = 'OrderCtrl/index/$1';                                  
$route['Order/(:num)/(:num)'] = 'OrderCtrl/index/$1/$2';                        
$route['Order/(:num)/(:num)/(:num)/(:num)'] = 'OrderCtrl/index/$1/$2/$3/$4';
$route['Order/(:num)/(:num)/(:any)/(:num)'] = 'OrderCtrl/index/$1/$2/$3/$4';     
$route['Order/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'OrderCtrl/index/$1/$2/$3/$4/$5';
$route['Order/(:any)'] = 'OrderCtrl/Buscar1/$1';                                
$route['Order/(:any)/(:num)/(:num)'] = 'OrderCtrl/Buscar1/$1/$2/$3';             
$route['Order/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'OrderCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Order/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'OrderCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Order/(:num)/(:any)'] = 'OrderCtrl/Buscar3/$1/$2';                     
$route['Order/(:any)/(:any)'] = 'OrderCtrl/Buscar2/$1/$2';                     
$route['Order/(:num)/(:num)/(:any)'] = 'OrderCtrl/Buscar4/$1/$2/$3';          
$route['Order/(:any)/(:num)/(:num)/(:any)'] = 'OrderCtrl/Buscar5/$1/$2/$3/$4';
$route['OrderMeta'] = 'OrderCtrl/MetaData';
// Ruta para las ordenes de exintores
$route['OrderEx'] = 'OrderExCtrl/index';                                             
$route['OrderEx/(:num)'] = 'OrderExCtrl/index/$1';                                  
$route['OrderEx/(:num)/(:num)'] = 'OrderExCtrl/index/$1/$2';                        
$route['OrderEx/(:num)/(:num)/(:num)/(:num)'] = 'OrderExCtrl/index/$1/$2/$3/$4';
$route['OrderEx/(:num)/(:num)/(:any)/(:num)'] = 'OrderExCtrl/index/$1/$2/$3/$4';     
$route['OrderEx/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'OrderExCtrl/index/$1/$2/$3/$4/$5';
$route['OrderEx/(:any)'] = 'OrderExCtrl/Buscar1/$1';                                
$route['OrderEx/(:any)/(:num)/(:num)'] = 'OrderExCtrl/Buscar1/$1/$2/$3';             
$route['OrderEx/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'OrderExCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['OrderEx/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'OrderExCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['OrderEx/(:num)/(:any)'] = 'OrderExCtrl/Buscar3/$1/$2';                     
$route['OrderEx/(:any)/(:any)'] = 'OrderExCtrl/Buscar2/$1/$2';                     
$route['OrderEx/(:num)/(:num)/(:any)'] = 'OrderExCtrl/Buscar4/$1/$2/$3';          
$route['OrderEx/(:any)/(:num)/(:num)/(:any)'] = 'OrderExCtrl/Buscar5/$1/$2/$3/$4';
$route['OrderExMeta'] = 'OrderExCtrl/MetaData';
// Rutas para los reportes de los extintores
$route['ReporExtinguisher'] = 'ReporExtinguisherCtrl/index';        
$route['ReporExtinguisher/(:num)'] = 'ReporExtinguisherCtrl/index/$1';                                  
$route['ReporExtinguisher/(:num)/(:num)'] = 'ReporExtinguisherCtrl/index/$1/$2';                        
$route['ReporExtinguisher/(:num)/(:num)/(:num)/(:num)'] = 'ReporExtinguisherCtrl/index/$1/$2/$3/$4';
$route['ReporExtinguisher/(:num)/(:num)/(:any)/(:num)'] = 'ReporExtinguisherCtrl/index/$1/$2/$3/$4';     
$route['ReporExtinguisher/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporExtinguisherCtrl/index/$1/$2/$3/$4/$5';
$route['ReporExtinguisher/(:any)'] = 'ReporExtinguisherCtrl/Buscar1/$1';                                
$route['ReporExtinguisher/(:any)/(:num)/(:num)'] = 'ReporExtinguisherCtrl/Buscar1/$1/$2/$3';             
$route['ReporExtinguisher/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporExtinguisherCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporExtinguisher/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporExtinguisherCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporExtinguisher/(:num)/(:any)'] = 'ReporExtinguisherCtrl/Buscar3/$1/$2';                     
$route['ReporExtinguisher/(:any)/(:any)'] = 'ReporExtinguisherCtrl/Buscar2/$1/$2';                     
$route['ReporExtinguisher/(:num)/(:num)/(:any)'] = 'ReporExtinguisherCtrl/Buscar4/$1/$2/$3';          
$route['ReporExtinguisher/(:any)/(:num)/(:num)/(:any)'] = 'ReporExtinguisherCtrl/Buscar5/$1/$2/$3/$4';
$route['ReporExtinguisherMeta'] = 'ReporExtinguisherCtrl/MetaData';
//Ruta Para los reportes de navio
$route['ReporShip'] = 'ReporShipCtrl/index';        
$route['ReporShip/(:num)'] = 'ReporShipCtrl/index/$1';                                  
$route['ReporShip/(:num)/(:num)'] = 'ReporShipCtrl/index/$1/$2';                        
$route['ReporShip/(:num)/(:num)/(:num)/(:num)'] = 'ReporShipCtrl/index/$1/$2/$3/$4';
$route['ReporShip/(:num)/(:num)/(:any)/(:num)'] = 'ReporShipCtrl/index/$1/$2/$3/$4';     
$route['ReporShip/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporShipCtrl/index/$1/$2/$3/$4/$5';
$route['ReporShip/(:any)'] = 'ReporShipCtrl/Buscar1/$1';                                
$route['ReporShip/(:any)/(:num)/(:num)'] = 'ReporShipCtrl/Buscar1/$1/$2/$3';             
$route['ReporShip/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporShipCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporShip/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporShipCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporShip/(:num)/(:any)'] = 'ReporShipCtrl/Buscar3/$1/$2';                     
$route['ReporShip/(:any)/(:any)'] = 'ReporShipCtrl/Buscar2/$1/$2';                     
$route['ReporShip/(:num)/(:num)/(:any)'] = 'ReporShipCtrl/Buscar4/$1/$2/$3';          
$route['ReporShip/(:any)/(:num)/(:num)/(:any)'] = 'ReporShipCtrl/Buscar5/$1/$2/$3/$4';
$route['ReporShipMeta'] = 'ReporShipCtrl/MetaData';
// Rutas para gestionar los detalles
$route['DetalleOrden'] = 'DetalleOrdenCtrl/index';                                             
$route['DetalleOrden/(:num)'] = 'DetalleOrdenCtrl/index/$1';                                  
$route['DetalleOrden/(:num)/(:num)'] = 'DetalleOrdenCtrl/index/$1/$2';                        
$route['DetalleOrden/(:num)/(:num)/(:num)/(:num)'] = 'DetalleOrdenCtrl/index/$1/$2/$3/$4';
$route['DetalleOrden/(:num)/(:num)/(:any)/(:num)'] = 'DetalleOrdenCtrl/index/$1/$2/$3/$4';     
$route['DetalleOrden/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'DetalleOrdenCtrl/index/$1/$2/$3/$4/$5';
$route['DetalleOrden/(:any)'] = 'DetalleOrdenCtrl/Buscar1/$1';                                
$route['DetalleOrden/(:any)/(:num)/(:num)'] = 'DetalleOrdenCtrl/Buscar1/$1/$2/$3';             
$route['DetalleOrden/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'DetalleOrdenCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['DetalleOrden/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'DetalleOrdenCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['DetalleOrden/(:num)/(:any)'] = 'DetalleOrdenCtrl/Buscar3/$1/$2';                     
$route['DetalleOrden/(:any)/(:any)'] = 'DetalleOrdenCtrl/Buscar2/$1/$2';                     
$route['DetalleOrden/(:num)/(:num)/(:any)'] = 'DetalleOrdenCtrl/Buscar4/$1/$2/$3';          
$route['DetalleOrden/(:any)/(:num)/(:num)/(:any)'] = 'DetalleOrdenCtrl/Buscar5/$1/$2/$3/$4';
$route['DetalleOrdenMeta'] = 'DetalleOrdenCtrl/MetaData';
// rutas para optener informacion del detalle de las ordenes ReporDetalleOrden

$route['ReporDetalleOrden'] = 'ReporDetalleOrdenCtrl/index';                                             
$route['ReporDetalleOrden/(:num)'] = 'ReporDetalleOrdenCtrl/index/$1';                                  
$route['ReporDetalleOrden/(:num)/(:num)'] = 'ReporDetalleOrdenCtrl/index/$1/$2';                        
$route['ReporDetalleOrden/(:num)/(:num)/(:num)/(:num)'] = 'ReporDetalleOrdenCtrl/index/$1/$2/$3/$4';
$route['ReporDetalleOrden/(:num)/(:num)/(:any)/(:num)'] = 'ReporDetalleOrdenCtrl/index/$1/$2/$3/$4';     
$route['ReporDetalleOrden/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporDetalleOrdenCtrl/index/$1/$2/$3/$4/$5';
$route['ReporDetalleOrden/(:any)'] = 'ReporDetalleOrdenCtrl/Buscar1/$1';                                
$route['ReporDetalleOrden/(:any)/(:num)/(:num)'] = 'ReporDetalleOrdenCtrl/Buscar1/$1/$2/$3';             
$route['ReporDetalleOrden/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporDetalleOrdenCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporDetalleOrden/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporDetalleOrdenCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporDetalleOrden/(:num)/(:any)'] = 'ReporDetalleOrdenCtrl/Buscar3/$1/$2';                     
$route['ReporDetalleOrden/(:any)/(:any)'] = 'ReporDetalleOrdenCtrl/Buscar2/$1/$2';                     
$route['ReporDetalleOrden/(:num)/(:num)/(:any)'] = 'ReporDetalleOrdenCtrl/Buscar4/$1/$2/$3';          
$route['ReporDetalleOrden/(:any)/(:num)/(:num)/(:any)'] = 'ReporDetalleOrdenCtrl/Buscar5/$1/$2/$3/$4';
$route['ReporDetalleOrdenMeta'] = 'ReporDetalleOrdenCtrl/MetaData';
// Reporte Detalle de Ordenes Extintores
$route['ReporDetalleOrdenEx'] = 'ReporDetalleOrdenExCtrl/index';                                             
$route['ReporDetalleOrdenEx/(:num)'] = 'ReporDetalleOrdenExCtrl/index/$1';                                  
$route['ReporDetalleOrdenEx/(:num)/(:num)'] = 'ReporDetalleOrdenExCtrl/index/$1/$2';                        
$route['ReporDetalleOrdenEx/(:num)/(:num)/(:num)/(:num)'] = 'ReporDetalleOrdenExCtrl/index/$1/$2/$3/$4';
$route['ReporDetalleOrdenEx/(:num)/(:num)/(:any)/(:num)'] = 'ReporDetalleOrdenExCtrl/index/$1/$2/$3/$4';     
$route['ReporDetalleOrdenEx/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporDetalleOrdenExCtrl/index/$1/$2/$3/$4/$5';
$route['ReporDetalleOrdenEx/(:any)'] = 'ReporDetalleOrdenExCtrl/Buscar1/$1';                                
$route['ReporDetalleOrdenEx/(:any)/(:num)/(:num)'] = 'ReporDetalleOrdenExCtrl/Buscar1/$1/$2/$3';             
$route['ReporDetalleOrdenEx/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporDetalleOrdenExCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporDetalleOrdenEx/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporDetalleOrdenExCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporDetalleOrdenEx/(:num)/(:any)'] = 'ReporDetalleOrdenExCtrl/Buscar3/$1/$2';                     
$route['ReporDetalleOrdenEx/(:any)/(:any)'] = 'ReporDetalleOrdenExCtrl/Buscar2/$1/$2';                     
$route['ReporDetalleOrdenEx/(:num)/(:num)/(:any)'] = 'ReporDetalleOrdenExCtrl/Buscar4/$1/$2/$3';          
$route['ReporDetalleOrdenEx/(:any)/(:num)/(:num)/(:any)'] = 'ReporDetalleOrdenExCtrl/Buscar5/$1/$2/$3/$4';
$route['ReporDetalleOrdenExMeta'] = 'ReporDetalleOrdenExCtrl/MetaData';
//Detalle de orden de Exintotres 
$route['DetalleOrdenEx'] = 'DetalleOrdenExCtrl/index';                                             
$route['DetalleOrdenEx/(:num)'] = 'DetalleOrdenExCtrl/index/$1';                                  
$route['DetalleOrdenEx/(:num)/(:num)'] = 'DetalleOrdenExCtrl/index/$1/$2';                        
$route['DetalleOrdenEx/(:num)/(:num)/(:num)/(:num)'] = 'DetalleOrdenExCtrl/index/$1/$2/$3/$4';
$route['DetalleOrdenEx/(:num)/(:num)/(:any)/(:num)'] = 'DetalleOrdenExCtrl/index/$1/$2/$3/$4';     
$route['DetalleOrdenEx/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'DetalleOrdenExCtrl/index/$1/$2/$3/$4/$5';
$route['DetalleOrdenEx/(:any)'] = 'DetalleOrdenExCtrl/Buscar1/$1';                                
$route['DetalleOrdenEx/(:any)/(:num)/(:num)'] = 'DetalleOrdenExCtrl/Buscar1/$1/$2/$3';             
$route['DetalleOrdenEx/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'DetalleOrdenExCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['DetalleOrdenEx/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'DetalleOrdenExCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['DetalleOrdenEx/(:num)/(:any)'] = 'DetalleOrdenExCtrl/Buscar3/$1/$2';                     
$route['DetalleOrdenEx/(:any)/(:any)'] = 'DetalleOrdenExCtrl/Buscar2/$1/$2';                     
$route['DetalleOrdenEx/(:num)/(:num)/(:any)'] = 'DetalleOrdenExCtrl/Buscar4/$1/$2/$3';          
$route['DetalleOrdenEx/(:any)/(:num)/(:num)/(:any)'] = 'DetalleOrdenExCtrl/Buscar5/$1/$2/$3/$4';
$route['DetalleOrdenExMeta'] = 'DetalleOrdenExCtrl/MetaData';

// Aqui vamos a gestionar las las actas Minutes
$route['Minutes'] = 'MinutesCtrl/index';                                             
$route['Minutes/(:num)'] = 'MinutesCtrl/index/$1';                                  
$route['Minutes/(:num)/(:num)'] = 'MinutesCtrl/index/$1/$2';                        
$route['Minutes/(:num)/(:num)/(:num)/(:num)'] = 'MinutesCtrl/index/$1/$2/$3/$4';
$route['Minutes/(:num)/(:num)/(:any)/(:num)'] = 'MinutesCtrl/index/$1/$2/$3/$4';     
$route['Minutes/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'MinutesCtrl/index/$1/$2/$3/$4/$5';
$route['Minutes/(:any)'] = 'MinutesCtrl/Buscar1/$1';                                
$route['Minutes/(:any)/(:num)/(:num)'] = 'MinutesCtrl/Buscar1/$1/$2/$3';             
$route['Minutes/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'MinutesCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Minutes/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'MinutesCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Minutes/(:num)/(:any)'] = 'MinutesCtrl/Buscar3/$1/$2';                     
$route['Minutes/(:any)/(:any)'] = 'MinutesCtrl/Buscar2/$1/$2';                     
$route['Minutes/(:num)/(:num)/(:any)'] = 'MinutesCtrl/Buscar4/$1/$2/$3';          
$route['Minutes/(:any)/(:num)/(:num)/(:any)'] = 'MinutesCtrl/Buscar5/$1/$2/$3/$4';
$route['MinutesMeta'] = 'MinutesCtrl/MetaData';
// Aqui vamos a gestionar las pruebas Proof
$route['Proof'] = 'ProofCtrl/index';                                             
$route['Proof/(:num)'] = 'ProofCtrl/index/$1';                                  
$route['Proof/(:num)/(:num)'] = 'ProofCtrl/index/$1/$2';                        
$route['Proof/(:num)/(:num)/(:num)/(:num)'] = 'ProofCtrl/index/$1/$2/$3/$4';
$route['Proof/(:num)/(:num)/(:any)/(:num)'] = 'ProofCtrl/index/$1/$2/$3/$4';     
$route['Proof/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ProofCtrl/index/$1/$2/$3/$4/$5';
$route['Proof/(:any)'] = 'ProofCtrl/Buscar1/$1';                                
$route['Proof/(:any)/(:num)/(:num)'] = 'ProofCtrl/Buscar1/$1/$2/$3';             
$route['Proof/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ProofCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Proof/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ProofCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Proof/(:num)/(:any)'] = 'ProofCtrl/Buscar3/$1/$2';                     
$route['Proof/(:any)/(:any)'] = 'ProofCtrl/Buscar2/$1/$2';                     
$route['Proof/(:num)/(:num)/(:any)'] = 'ProofCtrl/Buscar4/$1/$2/$3';          
$route['Proof/(:any)/(:num)/(:num)/(:any)'] = 'ProofCtrl/Buscar5/$1/$2/$3/$4';
$route['ProofMeta'] = 'ProofCtrl/MetaData';
// Aqui van las rutas para gestionar los extintores
$route['Extinguisher'] = 'ExtinguisherCtrl/index';                                             
$route['Extinguisher/(:num)'] = 'ExtinguisherCtrl/index/$1';                                  
$route['Extinguisher/(:num)/(:num)'] = 'ExtinguisherCtrl/index/$1/$2';                        
$route['Extinguisher/(:num)/(:num)/(:num)/(:num)'] = 'ExtinguisherCtrl/index/$1/$2/$3/$4';
$route['Extinguisher/(:num)/(:num)/(:any)/(:num)'] = 'ExtinguisherCtrl/index/$1/$2/$3/$4';     
$route['Extinguisher/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ExtinguisherCtrl/index/$1/$2/$3/$4/$5';
$route['Extinguisher/(:any)'] = 'ExtinguisherCtrl/Buscar1/$1';                                
$route['Extinguisher/(:any)/(:num)/(:num)'] = 'ExtinguisherCtrl/Buscar1/$1/$2/$3';             
$route['Extinguisher/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ExtinguisherCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Extinguisher/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ExtinguisherCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Extinguisher/(:num)/(:any)'] = 'ExtinguisherCtrl/Buscar3/$1/$2';                     
$route['Extinguisher/(:any)/(:any)'] = 'ExtinguisherCtrl/Buscar2/$1/$2';                     
$route['Extinguisher/(:num)/(:num)/(:any)'] = 'ExtinguisherCtrl/Buscar4/$1/$2/$3';          
$route['Extinguisher/(:any)/(:num)/(:num)/(:any)'] = 'ExtinguisherCtrl/Buscar5/$1/$2/$3/$4';
$route['ExtinguisherMeta'] = 'ExtinguisherCtrl/MetaData';
// rutas para gestionar extintores
$route['AirCylinder'] = 'AirCylinderCtrl/index';                                             
$route['AirCylinder/(:num)'] = 'AirCylinderCtrl/index/$1';                                  
$route['AirCylinder/(:num)/(:num)'] = 'AirCylinderCtrl/index/$1/$2';                        
$route['AirCylinder/(:num)/(:num)/(:num)/(:num)'] = 'AirCylinderCtrl/index/$1/$2/$3/$4';
$route['AirCylinder/(:num)/(:num)/(:any)/(:num)'] = 'AirCylinderCtrl/index/$1/$2/$3/$4';     
$route['AirCylinder/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'AirCylinderCtrl/index/$1/$2/$3/$4/$5';
$route['AirCylinder/(:any)'] = 'AirCylinderCtrl/Buscar1/$1';                                
$route['AirCylinder/(:any)/(:num)/(:num)'] = 'AirCylinderCtrl/Buscar1/$1/$2/$3';             
$route['AirCylinder/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'AirCylinderCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['AirCylinder/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'AirCylinderCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['AirCylinder/(:num)/(:any)'] = 'AirCylinderCtrl/Buscar3/$1/$2';                     
$route['AirCylinder/(:any)/(:any)'] = 'AirCylinderCtrl/Buscar2/$1/$2';                     
$route['AirCylinder/(:num)/(:num)/(:any)'] = 'AirCylinderCtrl/Buscar4/$1/$2/$3';          
$route['AirCylinder/(:any)/(:num)/(:num)/(:any)'] = 'AirCylinderCtrl/Buscar5/$1/$2/$3/$4';
$route['AirCylinderMeta'] = 'AirCylinderCtrl/MetaData';
// rutas permisos
$route['Permisos'] = 'PermisosCtrl/index';                                             
$route['Permisos/(:num)'] = 'PermisosCtrl/index/$1';                                  
$route['Permisos/(:num)/(:num)'] = 'PermisosCtrl/index/$1/$2';                        
$route['Permisos/(:num)/(:num)/(:num)/(:num)'] = 'PermisosCtrl/index/$1/$2/$3/$4';
$route['Permisos/(:num)/(:num)/(:any)/(:num)'] = 'PermisosCtrl/index/$1/$2/$3/$4';     
$route['Permisos/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'PermisosCtrl/index/$1/$2/$3/$4/$5';
$route['Permisos/(:any)'] = 'PermisosCtrl/Buscar1/$1';                                
$route['Permisos/(:any)/(:num)/(:num)'] = 'PermisosCtrl/Buscar1/$1/$2/$3';             
$route['Permisos/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'PermisosCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Permisos/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'PermisosCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Permisos/(:num)/(:any)'] = 'PermisosCtrl/Buscar3/$1/$2';                     
$route['Permisos/(:any)/(:any)'] = 'PermisosCtrl/Buscar2/$1/$2';                     
$route['Permisos/(:num)/(:num)/(:any)'] = 'PermisosCtrl/Buscar4/$1/$2/$3';          
$route['Permisos/(:any)/(:num)/(:num)/(:any)'] = 'PermisosCtrl/Buscar5/$1/$2/$3/$4';
$route['PermisosMeta'] = 'PermisosCtrl/MetaData';
// Reporte balsas Certificados
$route['ReporCertificadoBalsas'] = 'ReporCertificadoBalsasCtrl/index';                                             
$route['ReporCertificadoBalsas/(:num)'] = 'ReporCertificadoBalsasCtrl/index/$1';                                  
$route['ReporCertificadoBalsas/(:num)/(:num)'] = 'ReporCertificadoBalsasCtrl/index/$1/$2';                        
$route['ReporCertificadoBalsas/(:num)/(:num)/(:num)/(:num)'] = 'ReporCertificadoBalsasCtrl/index/$1/$2/$3/$4';
$route['ReporCertificadoBalsas/(:num)/(:num)/(:any)/(:num)'] = 'ReporCertificadoBalsasCtrl/index/$1/$2/$3/$4';     
$route['ReporCertificadoBalsas/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporCertificadoBalsasCtrl/index/$1/$2/$3/$4/$5';
$route['ReporCertificadoBalsas/(:any)'] = 'ReporCertificadoBalsasCtrl/Buscar1/$1';                                
$route['ReporCertificadoBalsas/(:any)/(:num)/(:num)'] = 'ReporCertificadoBalsasCtrl/Buscar1/$1/$2/$3';             
$route['ReporCertificadoBalsas/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporCertificadoBalsasCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporCertificadoBalsas/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporCertificadoBalsasCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporCertificadoBalsas/(:num)/(:any)'] = 'ReporCertificadoBalsasCtrl/Buscar3/$1/$2';                     
$route['ReporCertificadoBalsas/(:any)/(:any)'] = 'ReporCertificadoBalsasCtrl/Buscar2/$1/$2';                     
$route['ReporCertificadoBalsas/(:num)/(:num)/(:any)'] = 'ReporCertificadoBalsasCtrl/Buscar4/$1/$2/$3';          
$route['ReporCertificadoBalsas/(:any)/(:num)/(:num)/(:any)'] = 'ReporCertificadoBalsasCtrl/Buscar5/$1/$2/$3/$4';
$route['ReporCertificadoBalsasMeta'] = 'ReporCertificadoBalsasCtrl/MetaData';
// Ruta para las firmas de los usuarios
$route['Firma'] = 'FirmaCtrl/index';
// Ruta que defino los Certificados de balsas Salvavidas
$route['CertificadoBalsa/(:num)'] = 'CertificadoBalsaCtrl/index/$1';
$route['CertificadoBalsa/(:num)/(:any)'] = 'CertificadoBalsaCtrl/index/$1/$2';
$route['CertificadoBalsa/(:any)'] = 'BuscarCertificadoBalsasCtrl/index/$1';
// ruta para gestionar Certificados de actas de apertura
$route['CertificadoApertura/(:num)'] = 'CertificadoAperturaCtrl/index/$1';
$route['CertificadoApertura/(:num)/(:any)'] = 'CertificadoAperturaCtrl/index/$1/$2';
$route['CertificadoApertura/(:any)'] = 'BuscarCertificadoAperturaCtrl/index/$1';
// ruta para gestionar Certificados de actas de Insumos
$route['CertificadoInsumos/(:num)'] = 'CertificadoInsumosCtrl/index/$1';
$route['CertificadoInsumos/(:num)/(:any)'] = 'CertificadoInsumosCtrl/index/$1/$2';
$route['CertificadoInsumos/(:any)'] = 'BuscarCertificadoInsumosCtrl/index/$1';
// Ruta para gestionar el certificado de extintores
$route['CertificadoExtintores/(:num)'] = 'CertificadoExtintoresCtrl/index/$1';
$route['CertificadoExtintores/(:num)/(:any)'] = 'CertificadoExtintoresCtrl/index/$1/$2';
$route['CertificadoExtintores/(:any)'] = 'BuscarCertificadoExtintoresCtrl/index/$1';
// Ruta para gestionar el certificado de Traje de inmercion 
$route['CertificadoTraje/(:num)'] = 'CertificadoTrajeCtrl/index/$1';
$route['CertificadoTraje/(:num)/(:any)'] = 'CertificadoTrajeCtrl/index/$1/$2';
$route['CertificadoTraje/(:any)'] = 'BuscarCertificadoTrajeCtrl/index/$1';
// Ruta para gestionar el certificado de cilindro de aire 
$route['CertificadoCilindroAire/(:num)'] = 'CerCilAireCtrl/index/$1';
$route['CertificadoCilindroAire/(:num)/(:any)'] = 'CerCilAireCtrl/index/$1/$2';
$route['CertificadoCilindroAire/(:any)'] = 'BuscarCerCilAireCtrl/index/$1';
// Ruta para crear e imprimir Orden de trabajo extintores
$route['OrdenExtintores/(:num)'] = 'OrdenExtintoresCtrl/index/$1';
$route['OrdenExtintores/(:any)'] = 'OrdenExtintoresCtrl/index/$1';
$route['ImprOrdenMang'] = 'ImprOrdenMangCtrl/index';
$route['ImprOrdenMang/(:num)'] = 'ImprOrdenMangCtrl/index/$1';
$route['ImprOrdenMang/(:any)'] = 'ImprOrdenMangCtrl/index/$1';
$route['ImpOrdenTra/(:num)'] = 'ImpOrdenTraCtrl/index/$1';
$route['ImpOrdenTra/(:any)'] = 'ImpOrdenTraCtrl/index/$1';
// ruta para eviar los datos del menu principal
$route['Menu'] = 'MenuCtrl/index';

$route['Alarma'] = 'AlarmaCtrl/Alarma';
$route['Alarma2'] = 'AlarmaCtrl/Alarma2';
// Aqui Vamos a buscar los productos a la venta
$route['Articles'] = 'ArticlesCtrl/index';                                             
$route['Articles/(:num)'] = 'ArticlesCtrl/index/$1';                                  
$route['Articles/(:num)/(:num)'] = 'ArticlesCtrl/index/$1/$2';                        
$route['Articles/(:num)/(:num)/(:num)/(:num)'] = 'ArticlesCtrl/index/$1/$2/$3/$4';
$route['Articles/(:num)/(:num)/(:any)/(:num)'] = 'ArticlesCtrl/index/$1/$2/$3/$4';     
$route['Articles/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ArticlesCtrl/index/$1/$2/$3/$4/$5';
$route['Articles/(:any)'] = 'ArticlesCtrl/Buscar1/$1';                                
$route['Articles/(:any)/(:num)/(:num)'] = 'ArticlesCtrl/Buscar1/$1/$2/$3';             
$route['Articles/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ArticlesCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Articles/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ArticlesCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Articles/(:num)/(:any)'] = 'ArticlesCtrl/Buscar3/$1/$2';                     
$route['Articles/(:any)/(:any)'] = 'ArticlesCtrl/Buscar2/$1/$2';                     
$route['Articles/(:num)/(:num)/(:any)'] = 'ArticlesCtrl/Buscar4/$1/$2/$3';          
$route['Articles/(:any)/(:num)/(:num)/(:any)'] = 'ArticlesCtrl/Buscar5/$1/$2/$3/$4';
$route['ArticlesMeta'] = 'ArticlesCtrl/MetaData';
// Ruta para Realizar Venta
$route['Vender'] = 'VenderCtrl/index';

// Ruta para las ventas Temporales
$route['VentaTemp'] = 'VentaTempCtrl/index';                                            
$route['VentaTemp/(:num)'] = 'VentaTempCtrl/index/$1';                                  
$route['VentaTemp/(:num)/(:num)'] = 'VentaTempCtrl/index/$1/$2';                        
$route['VentaTemp/(:num)/(:num)/(:num)/(:num)'] = 'VentaTempCtrl/index/$1/$2/$3/$4';
$route['VentaTemp/(:num)/(:num)/(:any)/(:num)'] = 'VentaTempCtrl/index/$1/$2/$3/$4';     
$route['VentaTemp/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'VentaTempCtrl/index/$1/$2/$3/$4/$5';
$route['VentaTemp/(:any)'] = 'VentaTempCtrl/Buscar1/$1';                                
$route['VentaTemp/(:any)/(:num)/(:num)'] = 'VentaTempCtrl/Buscar1/$1/$2/$3';             
$route['VentaTemp/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'VentaTempCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['VentaTemp/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'VentaTempCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['VentaTemp/(:num)/(:any)'] = 'VentaTempCtrl/Buscar3/$1/$2';                     
$route['VentaTemp/(:any)/(:any)'] = 'VentaTempCtrl/Buscar2/$1/$2';                     
$route['VentaTemp/(:num)/(:num)/(:any)'] = 'VentaTempCtrl/Buscar4/$1/$2/$3';          
$route['VentaTemp/(:any)/(:num)/(:num)/(:any)'] = 'VentaTempCtrl/Buscar5/$1/$2/$3/$4';
$route['VentaTempMeta'] = 'VentaTempCtrl/MetaData';
$route['VentaTempPdf'] = 'VentaTempCtrl/Pdf';
// Ruta del modulo de reportes
$route['Report'] = 'ReportCtrl/index';                                            
$route['Report/(:num)'] = 'ReportCtrl/index/$1';                                  
$route['Report/(:num)/(:num)'] = 'ReportCtrl/index/$1/$2';                        
$route['Report/(:num)/(:num)/(:num)/(:num)'] = 'ReportCtrl/index/$1/$2/$3/$4';
$route['Report/(:num)/(:num)/(:any)/(:num)'] = 'ReportCtrl/index/$1/$2/$3/$4';     
$route['Report/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportCtrl/index/$1/$2/$3/$4/$5';
$route['Report/(:any)'] = 'ReportCtrl/Buscar1/$1';                                
$route['Report/(:any)/(:num)/(:num)'] = 'ReportCtrl/Buscar1/$1/$2/$3';             
$route['Report/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReportCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Report/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Report/(:num)/(:any)'] = 'ReportCtrl/Buscar3/$1/$2';                     
$route['Report/(:any)/(:any)'] = 'ReportCtrl/Buscar2/$1/$2';                     
$route['Report/(:num)/(:num)/(:any)'] = 'ReportCtrl/Buscar4/$1/$2/$3';          
$route['Report/(:any)/(:num)/(:num)/(:any)'] = 'ReportCtrl/Buscar5/$1/$2/$3/$4';
$route['ReportMeta'] = 'ReportCtrl/MetaData';
$route['ReportPdf'] = 'ReportCtrl/Pdf';
// Vamos a procesar los reportes 
$route['ReporWarehouse2'] = 'ReporWarehouse2Ctrl/index';                                            
$route['ReporWarehouse2/(:num)'] = 'ReporWarehouse2Ctrl/index/$1';                                  
$route['ReporWarehouse2/(:num)/(:num)'] = 'ReporWarehouse2Ctrl/index/$1/$2';                        
$route['ReporWarehouse2/(:num)/(:num)/(:any)/(:num)'] = 'ReporWarehouse2Ctrl/index/$1/$2/$3/$4';     
$route['ReporWarehouse2/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporWarehouse2Ctrl/index/$1/$2/$3/$4/$5';
$route['ReporWarehouse2/(:any)'] = 'ReporWarehouse2Ctrl/Buscar1/$1';                                
$route['ReporWarehouse2/(:any)/(:num)/(:num)'] = 'ReporWarehouse2Ctrl/Buscar1/$1/$2/$3';             
$route['ReporWarehouse2/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporWarehouse2Ctrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporWarehouse2/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporWarehouse2Ctrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporWarehouse2/(:num)/(:any)'] = 'ReporWarehouse2Ctrl/Buscar3/$1/$2';                     
$route['ReporWarehouse2/(:any)/(:any)'] = 'ReporWarehouse2Ctrl/Buscar2/$1/$2';                     
$route['ReporWarehouse2/(:num)/(:num)/(:any)'] = 'ReporWarehouse2Ctrl/Buscar4/$1/$2/$3';          
$route['ReporWarehouse2/(:any)/(:num)/(:num)/(:any)'] = 'ReporWarehouse2Ctrl/Buscar5/$1/$2/$3/$4';
$route['ReporWarehouse2Meta'] = 'ReporWarehouse2Ctrl/MetaData';
// Reporte de los movimientos dentro del almacen pa que sea serio
$route['ReporWareDetalle2'] = 'ReporWareDetalle2Ctrl/index';                                            
$route['ReporWareDetalle2/(:num)'] = 'ReporWareDetalle2Ctrl/index/$1';                                  
$route['ReporWareDetalle2/(:num)/(:num)'] = 'ReporWareDetalle2Ctrl/index/$1/$2';                        
$route['ReporWareDetalle2/(:num)/(:num)/(:any)/(:num)'] = 'ReporWareDetalle2Ctrl/index/$1/$2/$3/$4';     
$route['ReporWareDetalle2/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporWareDetalle2Ctrl/index/$1/$2/$3/$4/$5';
$route['ReporWareDetalle2/(:any)'] = 'ReporWareDetalle2Ctrl/Buscar1/$1';                                
$route['ReporWareDetalle2/(:any)/(:num)/(:num)'] = 'ReporWareDetalle2Ctrl/Buscar1/$1/$2/$3';             
$route['ReporWareDetalle2/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporWareDetalle2Ctrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporWareDetalle2/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporWareDetalle2Ctrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporWareDetalle2/(:num)/(:any)'] = 'ReporWareDetalle2Ctrl/Buscar3/$1/$2';                     
$route['ReporWareDetalle2/(:any)/(:any)'] = 'ReporWareDetalle2Ctrl/Buscar2/$1/$2';                     
$route['ReporWareDetalle2/(:num)/(:num)/(:any)'] = 'ReporWareDetalle2Ctrl/Buscar4/$1/$2/$3';          
$route['ReporWareDetalle2/(:any)/(:num)/(:num)/(:any)'] = 'ReporWareDetalle2Ctrl/Buscar5/$1/$2/$3/$4';
$route['ReporWareDetalle2Meta'] = 'ReporWareDetalle2Ctrl/MetaData';
// Gestionamos el reporte de las ventas
$route['ReporVentas'] = 'ReporVentasCtrl/index';                                            
$route['ReporVentas/(:num)'] = 'ReporVentasCtrl/index/$1';                                  
$route['ReporVentas/(:num)/(:num)'] = 'ReporVentasCtrl/index/$1/$2';                        
$route['ReporVentas/(:num)/(:num)/(:any)/(:num)'] = 'ReporVentasCtrl/index/$1/$2/$3/$4';     
$route['ReporVentas/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporVentasCtrl/index/$1/$2/$3/$4/$5';
$route['ReporVentas/(:any)'] = 'ReporVentasCtrl/Buscar1/$1';                                
$route['ReporVentas/(:any)/(:num)/(:num)'] = 'ReporVentasCtrl/Buscar1/$1/$2/$3';             
$route['ReporVentas/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporVentasCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporVentas/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporVentasCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporVentas/(:num)/(:any)'] = 'ReporVentasCtrl/Buscar3/$1/$2';                     
$route['ReporVentas/(:any)/(:any)'] = 'ReporVentasCtrl/Buscar2/$1/$2';                     
$route['ReporVentas/(:num)/(:num)/(:any)'] = 'ReporVentasCtrl/Buscar4/$1/$2/$3';          
$route['ReporVentas/(:any)/(:num)/(:num)/(:any)'] = 'ReporVentasCtrl/Buscar5/$1/$2/$3/$4';
$route['ReporVentasMeta'] = 'ReporVentasCtrl/MetaData';
// Ruta para buscar informacion de las Ventas
$route['Ventas'] = 'VentasCtrl/index';                                            
$route['Ventas/(:num)'] = 'VentasCtrl/index/$1';                                  
$route['Ventas/(:num)/(:num)'] = 'VentasCtrl/index/$1/$2';                        
$route['Ventas/(:num)/(:num)/(:any)/(:num)'] = 'VentasCtrl/index/$1/$2/$3/$4';     
$route['Ventas/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'VentasCtrl/index/$1/$2/$3/$4/$5';
$route['Ventas/(:any)'] = 'VentasCtrl/Buscar1/$1';                                
$route['Ventas/(:any)/(:num)/(:num)'] = 'VentasCtrl/Buscar1/$1/$2/$3';             
$route['Ventas/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'VentasCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Ventas/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'VentasCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Ventas/(:num)/(:any)'] = 'VentasCtrl/Buscar3/$1/$2';                     
$route['Ventas/(:any)/(:any)'] = 'VentasCtrl/Buscar2/$1/$2';                     
$route['Ventas/(:num)/(:num)/(:any)'] = 'VentasCtrl/Buscar4/$1/$2/$3';          
$route['Ventas/(:any)/(:num)/(:num)/(:any)'] = 'VentasCtrl/Buscar5/$1/$2/$3/$4';
$route['VentasMeta'] = 'VentasCtrl/MetaData';
// ruta para anular una venta

$route['AnularVenta/(:num)'] = 'AnularVentaCrtl/index/$1'; 
// reporte detalle de proveedores muestra los productos que trae cada vendedor
$route['ReportDetalleProveedor'] = 'ReportDetalleProveedorCtrl/index';                                            
$route['ReportDetalleProveedor/(:num)'] = 'ReportDetalleProveedorCtrl/index/$1';                                  
$route['ReportDetalleProveedor/(:num)/(:num)'] = 'ReportDetalleProveedorCtrl/index/$1/$2';                        
$route['ReportDetalleProveedor/(:num)/(:num)/(:any)/(:num)'] = 'ReportDetalleProveedorCtrl/index/$1/$2/$3/$4';     
$route['ReportDetalleProveedor/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportDetalleProveedorCtrl/index/$1/$2/$3/$4/$5';
$route['ReportDetalleProveedor/(:any)'] = 'ReportDetalleProveedorCtrl/Buscar1/$1';                                
$route['ReportDetalleProveedor/(:any)/(:num)/(:num)'] = 'ReportDetalleProveedorCtrl/Buscar1/$1/$2/$3';             
$route['ReportDetalleProveedor/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReportDetalleProveedorCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReportDetalleProveedor/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportDetalleProveedorCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReportDetalleProveedor/(:num)/(:any)'] = 'ReportDetalleProveedorCtrl/Buscar3/$1/$2';                     
$route['ReportDetalleProveedor/(:any)/(:any)'] = 'ReportDetalleProveedorCtrl/Buscar2/$1/$2';                     
$route['ReportDetalleProveedor/(:num)/(:num)/(:any)'] = 'ReportDetalleProveedorCtrl/Buscar4/$1/$2/$3';          
$route['ReportDetalleProveedor/(:any)/(:num)/(:num)/(:any)'] = 'ReportDetalleProveedorCtrl/Buscar5/$1/$2/$3/$4';
$route['ReportDetalleProveedorMeta'] = 'ReportDetalleProveedorCtrl/MetaData';
//Reporte ProducProv  muestra todos los proveedores que traen un producto determinado
$route['ProducProv'] = 'ProducProvCtrl/index';                                            
$route['ProducProv/(:num)'] = 'ProducProvCtrl/index/$1';                                  
$route['ProducProv/(:num)/(:num)'] = 'ProducProvCtrl/index/$1/$2';                        
$route['ProducProv/(:num)/(:num)/(:any)/(:num)'] = 'ProducProvCtrl/index/$1/$2/$3/$4';     
$route['ProducProv/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ProducProvCtrl/index/$1/$2/$3/$4/$5';
$route['ProducProv/(:any)'] = 'ProducProvCtrl/Buscar1/$1';                                
$route['ProducProv/(:any)/(:num)/(:num)'] = 'ProducProvCtrl/Buscar1/$1/$2/$3';             
$route['ProducProv/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ProducProvCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ProducProv/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ProducProvCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ProducProv/(:num)/(:any)'] = 'ProducProvCtrl/Buscar3/$1/$2';                     
$route['ProducProv/(:any)/(:any)'] = 'ProducProvCtrl/Buscar2/$1/$2';                     
$route['ProducProv/(:num)/(:num)/(:any)'] = 'ProducProvCtrl/Buscar4/$1/$2/$3';          
$route['ProducProv/(:any)/(:num)/(:num)/(:any)'] = 'ProducProvCtrl/Buscar5/$1/$2/$3/$4';
$route['ProducProvMeta'] = 'ProducProvCtrl/MetaData';
// aqui definimos las rutas de las unidades
$route['Unidades'] = 'UnidadesCtrl/index';                                            
$route['Unidades/(:num)'] = 'UnidadesCtrl/index/$1';                                  
$route['Unidades/(:num)/(:num)'] = 'UnidadesCtrl/index/$1/$2';                        
$route['Unidades/(:num)/(:num)/(:num)/(:num)'] = 'UnidadesCtrl/index/$1/$2/$3/$4';
$route['Unidades/(:num)/(:num)/(:any)/(:num)'] = 'UnidadesCtrl/index/$1/$2/$3/$4';     
$route['Unidades/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'UnidadesCtrl/index/$1/$2/$3/$4/$5';
$route['Unidades/(:any)'] = 'UnidadesCtrl/Buscar1/$1';                                
$route['Unidades/(:any)/(:num)/(:num)'] = 'UnidadesCtrl/Buscar1/$1/$2/$3';             
$route['Unidades/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'UnidadesCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Unidades/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'UnidadesCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Unidades/(:num)/(:any)'] = 'UnidadesCtrl/Buscar3/$1/$2';                     
$route['Unidades/(:any)/(:any)'] = 'UnidadesCtrl/Buscar2/$1/$2';                     
$route['Unidades/(:num)/(:num)/(:any)'] = 'UnidadesCtrl/Buscar4/$1/$2/$3';          
$route['Unidades/(:any)/(:num)/(:num)/(:any)'] = 'UnidadesCtrl/Buscar5/$1/$2/$3/$4';
$route['UnidadesMeta'] = 'UnidadesCtrl/MetaData';
$route['UnidadesPdf'] = 'UnidadesCtrl/Pdf';
//Modulo para ingresar las ordenes y certificados generales
$route['OrdenesG'] = 'OrdenesGCtrl/index';                                            
$route['OrdenesG/(:num)'] = 'OrdenesGCtrl/index/$1';                                  
$route['OrdenesG/(:num)/(:num)'] = 'OrdenesGCtrl/index/$1/$2';                        
$route['OrdenesG/(:num)/(:num)/(:any)/(:num)'] = 'OrdenesGCtrl/index/$1/$2/$3/$4';     
$route['OrdenesG/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'OrdenesGCtrl/index/$1/$2/$3/$4/$5';
$route['OrdenesG/(:any)'] = 'OrdenesGCtrl/Buscar1/$1';                                
$route['OrdenesG/(:any)/(:num)/(:num)'] = 'OrdenesGCtrl/Buscar1/$1/$2/$3';             
$route['OrdenesG/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'OrdenesGCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['OrdenesG/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'OrdenesGCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['OrdenesG/(:num)/(:any)'] = 'OrdenesGCtrl/Buscar3/$1/$2';                     
$route['OrdenesG/(:any)/(:any)'] = 'OrdenesGCtrl/Buscar2/$1/$2';                     
$route['OrdenesG/(:num)/(:num)/(:any)'] = 'OrdenesGCtrl/Buscar4/$1/$2/$3';          
$route['OrdenesG/(:any)/(:num)/(:num)/(:any)'] = 'OrdenesGCtrl/Buscar5/$1/$2/$3/$4';
$route['OrdenesGMeta'] = 'OrdenesGCtrl/MetaData';
// Rutas para gestionar los pedidos
$route['Pedidos'] = 'PedidosCtrl/index';                                            
$route['Pedidos/(:num)'] = 'PedidosCtrl/index/$1';                                  
$route['Pedidos/(:num)/(:num)'] = 'PedidosCtrl/index/$1/$2';                        
$route['Pedidos/(:num)/(:num)/(:num)/(:num)'] = 'PedidosCtrl/index/$1/$2/$3/$4';
$route['Pedidos/(:num)/(:num)/(:any)/(:num)'] = 'PedidosCtrl/index/$1/$2/$3/$4';     
$route['Pedidos/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'PedidosCtrl/index/$1/$2/$3/$4/$5';
$route['Pedidos/(:any)'] = 'PedidosCtrl/Buscar1/$1';                                
$route['Pedidos/(:any)/(:num)/(:num)'] = 'PedidosCtrl/Buscar1/$1/$2/$3';             
$route['Pedidos/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'PedidosCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Pedidos/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'PedidosCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Pedidos/(:num)/(:any)'] = 'PedidosCtrl/Buscar3/$1/$2';                     
$route['Pedidos/(:any)/(:any)'] = 'PedidosCtrl/Buscar2/$1/$2';                     
$route['Pedidos/(:num)/(:num)/(:any)'] = 'PedidosCtrl/Buscar4/$1/$2/$3';          
$route['Pedidos/(:any)/(:num)/(:num)/(:any)'] = 'PedidosCtrl/Buscar5/$1/$2/$3/$4';
$route['PedidosMeta'] = 'PedidosCtrl/MetaData';
$route['PedidosPdf'] = 'PedidosCtrl/Pdf';
$route['ReportPedidos'] = 'ReportPedidosCtrl/index';                                            
$route['ReportPedidos/(:num)'] = 'ReportPedidosCtrl/index/$1';                                  
$route['ReportPedidos/(:num)/(:num)'] = 'ReportPedidosCtrl/index/$1/$2';                        
$route['ReportPedidos/(:num)/(:num)/(:num)/(:num)'] = 'ReportPedidosCtrl/index/$1/$2/$3/$4';
$route['ReportPedidos/(:num)/(:num)/(:any)/(:num)'] = 'ReportPedidosCtrl/index/$1/$2/$3/$4';     
$route['ReportPedidos/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportPedidosCtrl/index/$1/$2/$3/$4/$5';
$route['ReportPedidos/(:any)'] = 'ReportPedidosCtrl/Buscar1/$1';                                
$route['ReportPedidos/(:any)/(:num)/(:num)'] = 'ReportPedidosCtrl/Buscar1/$1/$2/$3';             
$route['ReportPedidos/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReportPedidosCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReportPedidos/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportPedidosCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReportPedidos/(:num)/(:any)'] = 'ReportPedidosCtrl/Buscar3/$1/$2';                     
$route['ReportPedidos/(:any)/(:any)'] = 'ReportPedidosCtrl/Buscar2/$1/$2';                     
$route['ReportPedidos/(:num)/(:num)/(:any)'] = 'ReportPedidosCtrl/Buscar4/$1/$2/$3';          
$route['ReportPedidos/(:any)/(:num)/(:num)/(:any)'] = 'ReportPedidosCtrl/Buscar5/$1/$2/$3/$4';
$route['ReportPedidosMeta'] = 'ReportPedidosCtrl/MetaData';
$route['ReportPedidosPdf'] = 'ReportPedidosCtrl/Pdf';
$route['PruebaCorreo'] = 'PruebaCorreo/index';
$route['Refrescar'] = 'Refrescar/index';
$route["CodigoAux"] = 'CodigoAuxCtrl/index';
// Gestionamos el reporte de las ventas
$route['ReporVentas2'] = 'ReporVentas2Ctrl/index';                                            
$route['ReporVentas2/(:num)'] = 'ReporVentas2Ctrl/index/$1';                                  
$route['ReporVentas2/(:num)/(:num)'] = 'ReporVentas2Ctrl/index/$1/$2';                        
$route['ReporVentas2/(:num)/(:num)/(:any)/(:num)'] = 'ReporVentas2Ctrl/index/$1/$2/$3/$4';     
$route['ReporVentas2/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporVentas2Ctrl/index/$1/$2/$3/$4/$5';
$route['ReporVentas2/(:any)'] = 'ReporVentas2Ctrl/Buscar1/$1';                                
$route['ReporVentas2/(:any)/(:num)/(:num)'] = 'ReporVentas2Ctrl/Buscar1/$1/$2/$3';             
$route['ReporVentas2/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporVentas2Ctrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporVentas2/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporVentas2Ctrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporVentas2/(:num)/(:any)'] = 'ReporVentas2Ctrl/Buscar3/$1/$2';                     
$route['ReporVentas2/(:any)/(:any)'] = 'ReporVentas2Ctrl/Buscar2/$1/$2';                     
$route['ReporVentas2/(:num)/(:num)/(:any)'] = 'ReporVentas2Ctrl/Buscar4/$1/$2/$3';          
$route['ReporVentas2/(:any)/(:num)/(:num)/(:any)'] = 'ReporVentas2Ctrl/Buscar5/$1/$2/$3/$4';
$route['ReporVentas2Meta'] = 'ReporVentas2Ctrl/MetaData';
//Ruta de lioren 
$route['Lioren'] = 'ConsultaLiorenCtrl/index';
$route['OrdenGeneral/(:num)'] = 'OrdenGeneralCtrl/index/$1';
// Ruta para gestionar el certificado de extintores
$route['CertificadosGenerales/(:num)'] = 'CertificadosGenerales/index/$1';
$route['CertificadosGenerales/(:num)/(:any)'] = 'CertificadosGenerales/index/$1/$2';
$route['Certificados/(:any)'] = 'BuscarCertificados/index/$1';
// Ruta del modulo de ReportCertificadosGeneraleses
$route['ReportCertificadosGenerales'] = 'ReportCertificadosGeneralesCtrl/index';                                            
$route['ReportCertificadosGenerales/(:num)'] = 'ReportCertificadosGeneralesCtrl/index/$1';                                  
$route['ReportCertificadosGenerales/(:num)/(:num)'] = 'ReportCertificadosGeneralesCtrl/index/$1/$2';                        
$route['ReportCertificadosGenerales/(:num)/(:num)/(:num)/(:num)'] = 'ReportCertificadosGeneralesCtrl/index/$1/$2/$3/$4';
$route['ReportCertificadosGenerales/(:num)/(:num)/(:any)/(:num)'] = 'ReportCertificadosGeneralesCtrl/index/$1/$2/$3/$4';     
$route['ReportCertificadosGenerales/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportCertificadosGeneralesCtrl/index/$1/$2/$3/$4/$5';
$route['ReportCertificadosGenerales/(:any)'] = 'ReportCertificadosGeneralesCtrl/Buscar1/$1';                                
$route['ReportCertificadosGenerales/(:any)/(:num)/(:num)'] = 'ReportCertificadosGeneralesCtrl/Buscar1/$1/$2/$3';             
$route['ReportCertificadosGenerales/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReportCertificadosGeneralesCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReportCertificadosGenerales/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportCertificadosGeneralesCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReportCertificadosGenerales/(:num)/(:any)'] = 'ReportCertificadosGeneralesCtrl/Buscar3/$1/$2';                     
$route['ReportCertificadosGenerales/(:any)/(:any)'] = 'ReportCertificadosGeneralesCtrl/Buscar2/$1/$2';                     
$route['ReportCertificadosGenerales/(:num)/(:num)/(:any)'] = 'ReportCertificadosGeneralesCtrl/Buscar4/$1/$2/$3';          
$route['ReportCertificadosGenerales/(:any)/(:num)/(:num)/(:any)'] = 'ReportCertificadosGeneralesCtrl/Buscar5/$1/$2/$3/$4';
$route['ReportCertificadosGeneralesMeta'] = 'ReportCertificadosGeneralesCtrl/MetaData';
$route['ReportCertificadosGeneralesPdf'] = 'ReportCertificadosGeneralesCtrl/Pdf';
// Rutas reportes de pedido
// Rutas de configuracion del sistema 
$route['Config'] = 'ConfigCtrl/index';                                            
$route['Config/(:num)'] = 'ConfigCtrl/index/$1';                                  
$route['Config/(:num)/(:num)'] = 'ConfigCtrl/index/$1/$2';                        
$route['Config/(:num)/(:num)/(:num)/(:num)'] = 'ConfigCtrl/index/$1/$2/$3/$4';
$route['Config/(:num)/(:num)/(:any)/(:num)'] = 'ConfigCtrl/index/$1/$2/$3/$4';     
$route['Config/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ConfigCtrl/index/$1/$2/$3/$4/$5';
$route['Config/(:any)'] = 'ConfigCtrl/Buscar1/$1';                                
$route['Config/(:any)/(:num)/(:num)'] = 'ConfigCtrl/Buscar1/$1/$2/$3';             
$route['Config/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ConfigCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Config/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ConfigCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Config/(:num)/(:any)'] = 'ConfigCtrl/Buscar3/$1/$2';                     
$route['Config/(:any)/(:any)'] = 'ConfigCtrl/Buscar2/$1/$2';                     
$route['Config/(:num)/(:num)/(:any)'] = 'ConfigCtrl/Buscar4/$1/$2/$3';          
$route['Config/(:any)/(:num)/(:num)/(:any)'] = 'ConfigCtrl/Buscar5/$1/$2/$3/$4';
$route['ConfigMeta'] = 'ConfigCtrl/MetaData';
$route['ConfigPdf'] = 'ConfigCtrl/Pdf';
// empoind de reporte de alarma de existencia 
$route['ReportAlarmaExistencia'] = 'ReportAlarmaExistenciaCtrl/index';                                            
$route['ReportAlarmaExistencia/(:num)'] = 'ReportAlarmaExistenciaCtrl/index/$1';                                  
$route['ReportAlarmaExistencia/(:num)/(:num)'] = 'ReportAlarmaExistenciaCtrl/index/$1/$2';                        
$route['ReportAlarmaExistencia/(:num)/(:num)/(:num)/(:num)'] = 'ReportAlarmaExistenciaCtrl/index/$1/$2/$3/$4';
$route['ReportAlarmaExistencia/(:num)/(:num)/(:any)/(:num)'] = 'ReportAlarmaExistenciaCtrl/index/$1/$2/$3/$4';     
$route['ReportAlarmaExistencia/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportAlarmaExistenciaCtrl/index/$1/$2/$3/$4/$5';
$route['ReportAlarmaExistencia/(:any)'] = 'ReportAlarmaExistenciaCtrl/Buscar1/$1';                                
$route['ReportAlarmaExistencia/(:any)/(:num)/(:num)'] = 'ReportAlarmaExistenciaCtrl/Buscar1/$1/$2/$3';             
$route['ReportAlarmaExistencia/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReportAlarmaExistenciaCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReportAlarmaExistencia/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportAlarmaExistenciaCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReportAlarmaExistencia/(:num)/(:any)'] = 'ReportAlarmaExistenciaCtrl/Buscar3/$1/$2';                     
$route['ReportAlarmaExistencia/(:any)/(:any)'] = 'ReportAlarmaExistenciaCtrl/Buscar2/$1/$2';                     
$route['ReportAlarmaExistencia/(:num)/(:num)/(:any)'] = 'ReportAlarmaExistenciaCtrl/Buscar4/$1/$2/$3';          
$route['ReportAlarmaExistencia/(:any)/(:num)/(:num)/(:any)'] = 'ReportAlarmaExistenciaCtrl/Buscar5/$1/$2/$3/$4';
$route['ReportAlarmaExistenciaMeta'] = 'ReportAlarmaExistenciaCtrl/MetaData';
$route['ReportAlarmaExistenciaPdf'] = 'ReportAlarmaExistenciaCtrl/Pdf';
// reporta de alarmas de vencimiento de producto
$route['ReportAlarmaVence'] = 'ReportAlarmaVenceCtrl/index';                                            
$route['ReportAlarmaVence/(:num)'] = 'ReportAlarmaVenceCtrl/index/$1';                                  
$route['ReportAlarmaVence/(:num)/(:num)'] = 'ReportAlarmaVenceCtrl/index/$1/$2';                        
$route['ReportAlarmaVence/(:num)/(:num)/(:num)/(:num)'] = 'ReportAlarmaVenceCtrl/index/$1/$2/$3/$4';
$route['ReportAlarmaVence/(:num)/(:num)/(:any)/(:num)'] = 'ReportAlarmaVenceCtrl/index/$1/$2/$3/$4';     
$route['ReportAlarmaVence/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportAlarmaVenceCtrl/index/$1/$2/$3/$4/$5';
$route['ReportAlarmaVence/(:any)'] = 'ReportAlarmaVenceCtrl/Buscar1/$1';                                
$route['ReportAlarmaVence/(:any)/(:num)/(:num)'] = 'ReportAlarmaVenceCtrl/Buscar1/$1/$2/$3';             
$route['ReportAlarmaVence/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReportAlarmaVenceCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReportAlarmaVence/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReportAlarmaVenceCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReportAlarmaVence/(:num)/(:any)'] = 'ReportAlarmaVenceCtrl/Buscar3/$1/$2';                     
$route['ReportAlarmaVence/(:any)/(:any)'] = 'ReportAlarmaVenceCtrl/Buscar2/$1/$2';                     
$route['ReportAlarmaVence/(:num)/(:num)/(:any)'] = 'ReportAlarmaVenceCtrl/Buscar4/$1/$2/$3';          
$route['ReportAlarmaVence/(:any)/(:num)/(:num)/(:any)'] = 'ReportAlarmaVenceCtrl/Buscar5/$1/$2/$3/$4';
$route['ReportAlarmaVenceMeta'] = 'ReportAlarmaVenceCtrl/MetaData';
$route['ReportAlarmaVencePdf'] = 'ReportAlarmaVenceCtrl/Pdf';
// Ruta para acceso a wordpress
$route['Wordpress'] = 'WordpressCtrl/index';
$route['Wordpress/(:any)'] ='WordpressCtrl/index/$1';
$route['Wordpress/(:num)/(:num)'] ='WordpressCtrl/index/$1/$2';
$route['Wordpress/(:any)/(:num)/(:num)'] ='WordpressCtrl/index/$1/$2/$3';
// solicitamos las impresoras de liores 
$route['Prints']='PrintsCtrl/index';
//Create Data Base
$route['CreateDataBase'] = 'DataBaseCtrl/index';
// Aqui Administraremos los Usuarios
$route['Admin'] = 'UserDbCtrl/index';                                            
$route['Admin/(:num)'] = 'UserDbCtrl/index/$1';                                  
$route['Admin/(:num)/(:num)'] = 'UserDbCtrl/index/$1/$2';                        
$route['Admin/(:num)/(:num)/(:num)/(:num)'] = 'UserDbCtrl/index/$1/$2/$3/$4';
$route['Admin/(:num)/(:num)/(:any)/(:num)'] = 'UserDbCtrl/index/$1/$2/$3/$4';     
$route['Admin/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'UserDbCtrl/index/$1/$2/$3/$4/$5';
$route['Admin/(:any)'] = 'UserDbCtrl/Buscar1/$1';                                
$route['Admin/(:any)/(:num)/(:num)'] = 'UserDbCtrl/Buscar1/$1/$2/$3';             
$route['Admin/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'UserDbCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Admin/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'UserDbCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Admin/(:num)/(:any)'] = 'UserDbCtrl/Buscar3/$1/$2';                     
$route['Admin/(:any)/(:any)'] = 'UserDbCtrl/Buscar2/$1/$2';                     
$route['Admin/(:num)/(:num)/(:any)'] = 'UserDbCtrl/Buscar4/$1/$2/$3';          
$route['Admin/(:any)/(:num)/(:num)/(:any)'] = 'UserDbCtrl/Buscar5/$1/$2/$3/$4';
$route['AdminMeta'] = 'UserDbCtrl/MetaData';
$route['AdminPdf'] = 'UserDbCtrl/Pdf';
// Rutas de reporte de venta a credito
$route['ReporVentasCredito'] = 'ReporVentasCreditoCtrl/index';                                            
$route['ReporVentasCredito/(:num)'] = 'ReporVentasCreditoCtrl/index/$1';                                  
$route['ReporVentasCredito/(:num)/(:num)'] = 'ReporVentasCreditoCtrl/index/$1/$2';                        
$route['ReporVentasCredito/(:num)/(:num)/(:any)/(:num)'] = 'ReporVentasCreditoCtrl/index/$1/$2/$3/$4';     
$route['ReporVentasCredito/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporVentasCreditoCtrl/index/$1/$2/$3/$4/$5';
$route['ReporVentasCredito/(:any)'] = 'ReporVentasCreditoCtrl/Buscar1/$1';                                
$route['ReporVentasCredito/(:any)/(:num)/(:num)'] = 'ReporVentasCreditoCtrl/Buscar1/$1/$2/$3';             
$route['ReporVentasCredito/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'ReporVentasCreditoCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['ReporVentasCredito/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'ReporVentasCreditoCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['ReporVentasCredito/(:num)/(:any)'] = 'ReporVentasCreditoCtrl/Buscar3/$1/$2';                     
$route['ReporVentasCredito/(:any)/(:any)'] = 'ReporVentasCreditoCtrl/Buscar2/$1/$2';                     
$route['ReporVentasCredito/(:num)/(:num)/(:any)'] = 'ReporVentasCreditoCtrl/Buscar4/$1/$2/$3';          
$route['ReporVentasCredito/(:any)/(:num)/(:num)/(:any)'] = 'ReporVentasCreditoCtrl/Buscar5/$1/$2/$3/$4';
$route['ReporVentasCreditoMeta'] = 'ReporVentasCreditoCtrl/MetaData';

// Rutas para gestionar la tabla Creditos 
$route['Creditos'] = 'CreditosCtrl/index';                                            
$route['Creditos/(:num)'] = 'CreditosCtrl/index/$1';                                  
$route['Creditos/(:num)/(:num)'] = 'CreditosCtrl/index/$1/$2';                        
$route['Creditos/(:num)/(:num)/(:num)/(:num)'] = 'CreditosCtrl/index/$1/$2/$3/$4';
$route['Creditos/(:num)/(:num)/(:any)/(:num)'] = 'CreditosCtrl/index/$1/$2/$3/$4';     
$route['Creditos/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'CreditosCtrl/index/$1/$2/$3/$4/$5';
$route['Creditos/(:any)'] = 'CreditosCtrl/Buscar1/$1';                                
$route['Creditos/(:any)/(:num)/(:num)'] = 'CreditosCtrl/Buscar1/$1/$2/$3';             
$route['Creditos/(:any)/(:num)/(:num)/(:any)/(:num)'] = 'CreditosCtrl/Buscar1/$1/$2/$3/$4/$5';   
$route['Creditos/(:any)/(:num)/(:num)/(:any)/(:num)/(:any)'] = 'CreditosCtrl/Buscar1/$1/$2/$3/$4/$5/$6'; 
$route['Creditos/(:num)/(:any)'] = 'CreditosCtrl/Buscar3/$1/$2';                     
$route['Creditos/(:any)/(:any)'] = 'CreditosCtrl/Buscar2/$1/$2';                     
$route['Creditos/(:num)/(:num)/(:any)'] = 'CreditosCtrl/Buscar4/$1/$2/$3';          
$route['Creditos/(:any)/(:num)/(:num)/(:any)'] = 'CreditosCtrl/Buscar5/$1/$2/$3/$4';
$route['CreditosMeta'] = 'CreditosCtrl/MetaData';
$route['CreditosPdf'] = 'CreditosCtrl/Pdf';
// Rutas de pago de creditos
$route['PagoCredito']='PagoCreditoCtrl/index';
//esto va al final
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;