<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ReporCertificadoBalsasModels extends CI_Model
{

    private $Tabla = "balsas";
    private $Delimitador= "|";
    private $Separador = "^";

    private $CamposTablas = ["cliente.Nombres","cliente.Apellidos","cliente.Rut","cliente.Telefono","cliente.Correo", "navio.Nombre","balsas.Marca","navio.ID", "navio.Nombre", "navio.Tipo","navio.Matricula","navio.Serial","balsas.ID","balsas.Serial","balsas.Capacidad","balsas.Fabricacion","balsas.Vence","balsas.Certificado","balsas.VenceCer", "actas.ID","APERTURA.ID","balsas.StatusCertificado","actas.Pack","APERTURA.Certificado","CONCAT(balsas.Certificado)", "cliente.Region", "cliente.Comuna", "cliente.Ciudad"];
    private $Select = ['Nombre'=>['date'=>"Client",'option'=>[],'filter'=>'s','Datos'=>'s02',"necessary"=>true],'Apellido'=>['date'=>"Client",'option'=>[],'filter'=>'s','Datos'=>'s03',"necessary"=>true],'Rut'=>['date'=>"Client",'option'=>[],'filter'=>'s','Datos'=>'s01',"necessary"=>true],'Embarcacion'=>['date'=>"Ship",'option'=>[],'filter'=>'s','Datos'=>'s01',"necessary"=>true],'Matricula'=>['date'=>"Ship",'option'=>[],'filter'=>'s','Datos'=>'s05',"necessary"=>true],'Balsa'=>['date'=>"Raft",'option'=>[],'filter'=>'s','Datos'=>'s02',"necessary"=>true],'Region'=>['date'=>"",'option'=>
    [""=>"",
    "1"=>"Región de Arica y Parinacota",
    "2"=>"Región de Tarapacá",
    "3"=>"Región de Antofagasta",
    "4"=>"Región de Atacama",
    "5"=>"Región de Coquimbo", 
    "6"=>"Región de Valparaíso",
    "7"=>"Región del Libertador General Bernardo O'Higgins",
    "8"=>"Región del Maule",
    "9"=>"Región del Biobío",
    "10"=>"Región de La Araucanía",
    "11"=>"Región de Los Ríos",
    "12"=>"Región de Los Lagos",
    "13"=>"Región Aysén del General Carlos Ibáñez del Campo",
    "14"=>"Región de Magallanes y de la Antártica Chilena",
    "27"=>"Región de Ñuble",
    ]
    ,'filter'=>'','Datos'=>"", "necessary"=>true],'Tecnico'=>['date'=>"User",'option'=>[],'filter'=>'s','Datos'=>'s02',"necessary"=>false],
    'Comuna'=>['date'=>"",'option'=>
    [""=>"",]
    ,'filter'=>'','Datos'=>"", "necessary"=>true],'Tecnico'=>['date'=>"User",'option'=>[],'filter'=>'s','Datos'=>'s02',"necessary"=>false],
    'Ciudad'=>['date'=>"",'option'=>
    [""=>"",]
    ,'filter'=>'','Datos'=>"", "necessary"=>true],'Tecnico'=>['date'=>"User",'option'=>[],'filter'=>'s','Datos'=>'s02',"necessary"=>false]];
  
    private function InitJoin(){
        $this->db->join("navio"," balsas.Embarcacion = navio.ID","INNER",false);
        $this->db->join("cliente","cliente.CodigoCl = navio.Armador","INNER",false);
        $this->db->join("actas","actas.Certificado  =  balsas.Certificado AND actas.Certificado <> ''","LEFT",false);
        $this->db->join("detalleorden","detalleorden.ID  =  actas.Detalle","LEFT",false);
        $this->db->join("actas AS APERTURA","APERTURA.Detalle  = detalleorden.ID AND detalleorden.ID = APERTURA.Detalle AND APERTURA.Tipo = '1' ","LEFT",false);
      // $this->db->where('detalleorden.Status',$this->db->escape("Activo"),false);
       
       }
    private function ValidarCdProducto($CD){
        
        return $CD;

    }
 



    private function Filtros($Filtros){
        $Filtros= str_replace('ø','/',$Filtros);
        $arr1 = explode($this->Delimitador,$Filtros);
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
           
            $posicion_coincidencia = strpos($arr1[$i], $this->Separador);
            if(  $posicion_coincidencia != FALSE ){
              $Array2 = explode($this->Separador,$arr1[$i]);
              $Array2[0]= $this->columna($Array2[0]);
              if($Array2[0]==="producto.CodigoP")
              {
                $Array2[1]= $this->db->escape($this->ValidarCdProducto($Array2[1]));
              }else{
                $Array2[1]= $this->db->escape($Array2[1]); 
              }
               
              $arr1[$i] =  $Array2;
            }else {
                $arr1[$i]= array("Todo", $arr1[$i]);
            }
        }
        return  $arr1;
    }

   
    private  function columna($id = null,$Mascara = false){
        $fields = $this->CamposTablas;
        if($id === null){
          
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                $fields[$i] =  $fields[$i]. " AS ". $this->Mascara($fields[$i]);
            }
            return $fields;

        }

        if(is_numeric($id)===false){
            $array_num = count($fields);
            for ($i = 0; $i < $array_num; ++$i){
                if($id === $fields[$i] ||  $this->Mascara($fields[$i]) === $id ){
                    if($Mascara=== false){
                        return $fields[$i];
                    }else{
                        return $fields[$i]. " AS ". $this->Mascara($fields[$i]);
                    }
                  
                }
              
            }
            return $fields[0];
        }else{

       

        if($Mascara === false){
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)];
              }else{
                return $fields[0];
              }
        }else{
            if(intval($id) < count($fields) && intval($id) > 0 ){
                return  $fields[intval($id)]. " AS ". $this->Mascara($fields[intval($id)]);
              }else{
                return $fields[0]. " AS ". $this->Mascara($fields[0]);
              }        
        }
    }
       
    }
    private function Columnas($col = null,$Mascara = false){
          if($col=== null){
           $Arra =  $this->columna(null);
           return $Arra;
          }

        $Colu = substr($col, 1);
        $posicion_coincidencia = strpos($Colu, $this->Delimitador);
        if(  $posicion_coincidencia === FALSE ){
            $arr1 = str_split($Colu);
        }else{
            $arr1 = explode($this->Delimitador,$Colu);
        }
     
        $array_num = count($arr1);
        for ($i = 0; $i < $array_num; ++$i){
            $arr1[$i] =  $this->columna($arr1[$i],$Mascara);
        }
        return $arr1;
    }
    public function getReporCertificadoBalsas($id=NULL)
    {
       
       if ($id === NULL){
        $this->db->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
     
       }else{
          
           $Columna = $this->columna(0);
           $this->db->select($this->Columnas(),false);
           $this->InitJoin();
           $this->db->where($this->Tabla.'.ID',$this->db->escape("$id"),false);
           return  $this->db->get($this->Tabla)->result();

       }
       
    }
    public function getReporCertificadoBalsasLimite($Canti,$Desde){
        $this->db->select($this->Columnas(),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReporCertificadoBalsasLimiteOrden($Canti,$Desde,$Columna,$Orden){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
     
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        $this->db->select($this->Columnas(),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReporCertificadoBalsasLimiteOrdenColumnas($Canti,$Desde,$Columna,$Orden,$Columnas){
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        $this->db->order_by($this->columna($Columna), $Direccion);
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReporCertificadoBalsasIdColum($id,$Columnas){
       
        $this->db->select($this->Columnas($Columnas,true),false);
        $Columna = $this->columna(0);
        $this->InitJoin();
        $this->db->where($Columna,$this->db->escape("$id"),false);
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReporCertificadoBalsasLimiteColum($Canti,$Desde,$Columnas){
        $this->db->select($this->Columnas($Columnas,true),false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
    }
    public function getReporCertificadoBalsasFiltro($Filtros){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status <>',"'sdswe')",false ); 
        }
      
        $this->db->select($this->Columnas(),false);
     return  $this->db->get($this->Tabla)->result();
      
    }
    private function total(){
        $this->db->select("count(*) As Total",false);
        $this->InitJoin();
        return  $this->db->get($this->Tabla)->result();
    }
    public function getReporCertificadoBalsasFiltroLimite($Filtros,$Canti,$Desde){
      
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status <>',"'wdsws')",false ); 
        }
        $this->db->select($this->Columnas(),false);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReporCertificadoBalsasFiltroLimiteOrden($Filtros,$Canti,$Desde,$Columna,$Orden){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status <>',"'swsad')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
        $this->db->select($this->Columnas(),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReporCertificadoBalsasFiltroLimiteOrdenColumnas($Filtros,$Canti,$Desde,$Columna,$Orden,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status <>',"'sdwds')",false ); 
        }
        $Direccion ="Error en el Orden";
        $Direccion = $Orden ==="0" ? "ASC" :   $Direccion;
        $Direccion = $Orden ==="1" ? "DESC" :   $Direccion;
        if($Direccion ==="Error en el Orden" ) 
        {
            return array("Error"=> $Direccion);
        }
        
       
     
     $this->db->select($this->Columnas($Columnas,true),false);
     $this->db->order_by($this->columna($Columna), $Direccion);
     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
    public function getReporCertificadoBalsasFiltroColumnas($Filtros,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status <>',"'sxs')",false ); 
        }
        $this->db->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla)->result();
      
    }

    public function getReporCertificadoBalsasFiltroLimitesColumnas($Filtros,$Canti,$Desde,$Columnas){
        $Filtro = substr($Filtros, 1);
        $cont = 0;
      $arrayconsulta=  $this->Filtros($Filtro);
      $this->InitJoin();
      $array_num = count($arrayconsulta);
        for ($i = 0; $i < $array_num; ++$i){
           if($arrayconsulta[$i][0] != "Todo"){
            $this->db->where($arrayconsulta[$i][0],$arrayconsulta[$i][1],false);
           }else{
            $cont++;
           }
        }
        if($cont >0){
            $fields = $this->CamposTablas;
            $poli=false;
         
            for ($i = 0; $i < $array_num; ++$i){
            if($arrayconsulta[$i][0] === "Todo"){
                 for($e =0 ; $e <count( $fields)-1; ++$e )
                 {
                if( $poli===false){
                    $this->db->like('('.$fields[$e],$arrayconsulta[$i][1],'both',false );
                    $poli= true; 
                }else{ 
                    $this->db->or_like($fields[$e],$arrayconsulta[$i][1],'both',false);
                }
            }
            $this->db->or_where($fields[count( $fields)-1].' LIKE',"'%".$arrayconsulta[$i][1]."%')",false );
            $this->db->like('('.$this->Tabla.".Status",$arrayconsulta[$i][1],'both',false );
               }
            }
            $this->db->or_where($this->Tabla.'.Status <>',"'sds')",false ); 
        }
        $this->db->select($this->Columnas($Columnas,true),false);

     return  $this->db->get($this->Tabla,$Canti,$Desde)->result();
      
    }
   
// desde aqui comianza la configuracion

    private function Mascara($Clave){
        //Código
$ArrayReporCertificadoBalsas["balsas.ID"]=utf8_encode("CodigoBalsa");        
$ArrayReporCertificadoBalsas["cliente.Nombres"]= "Armador";
$ArrayReporCertificadoBalsas["cliente.Apellidos"]= "Apellido";
$ArrayReporCertificadoBalsas["cliente.Rut"]=  "Rut";
$ArrayReporCertificadoBalsas["cliente.Telefono"]=  utf8_encode('Teléfono');
$ArrayReporCertificadoBalsas["cliente.Correo"]= utf8_encode('Email');
$ArrayReporCertificadoBalsas["balsas.Marca"] = "Marca";
$ArrayReporCertificadoBalsas["navio.ID"]= "IDNAVIO";
$ArrayReporCertificadoBalsas["navio.Nombre"]="Embarcacion";
$ArrayReporCertificadoBalsas["navio.Tipo"]= 'NAVIOTipo';
$ArrayReporCertificadoBalsas["navio.Matricula"]= 'NAVIOMAtricula';
$ArrayReporCertificadoBalsas["navio.Serial"]="EmbarcacionSerial" ;
$ArrayReporCertificadoBalsas["balsas.Serial"]= utf8_encode('Balsa');
$ArrayReporCertificadoBalsas["balsas.Capacidad"]=  "Capacidad";
$ArrayReporCertificadoBalsas["balsas.Fabricacion"]=  "FabricacionBalsa";
$ArrayReporCertificadoBalsas["balsas.Vence"]= "VenceBalsa" ;
$ArrayReporCertificadoBalsas["balsas.Certificado"]= "Certificado";
$ArrayReporCertificadoBalsas["balsas.VenceCer"]= "VenceCert";
$ArrayReporCertificadoBalsas["actas.ID"]= "Insumos";
$ArrayReporCertificadoBalsas["APERTURA.ID"]= "Apertura";
$ArrayReporCertificadoBalsas["balsas.StatusCertificado"]= "Status";
$ArrayReporCertificadoBalsas["actas.Pack"]= "PACK";
$ArrayReporCertificadoBalsas["APERTURA.Certificado"]= "CerApertura";
$ArrayReporCertificadoBalsas["CONCAT(balsas.Certificado)"]= 'QR';
$ArrayReporCertificadoBalsas["cliente.Region"]= utf8_encode('Región');
$ArrayReporCertificadoBalsas["cliente.Comuna"]= utf8_encode('Comuna');
$ArrayReporCertificadoBalsas["cliente.Ciudad"]= utf8_encode('Ciudad');
 

if (isset($ArrayReporCertificadoBalsas[$Clave])){
return $ArrayReporCertificadoBalsas[$Clave];
}else{
return $Clave;
}
}

    private function verificarExistencia($dato,$Array)
    {
        $array_num = count($Array);
        for ($id = 0; $id < $array_num; ++$id){
            if($Array[$id]["nombre"] == $dato){
              return $id;
            }
        }
        return false;
    }






   Public function MetaData($Mascara = true){
    $meta3 = array();
    $meta2 = array();
    $meta3['Balsa'] = [
        "name"=> 'Balsa',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Raft',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s02',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Embarcacion'] = [
        "name"=> 'Embarcacion',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Ship',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s01',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Rut'] = [
        "name"=> 'Rut',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Client',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s01',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Apellido'] = [
        "name"=> 'Apellido',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Client',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s03',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Armador'] = [
        "name"=> 'Nombre',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'Client',
        "option"=>[],
        "filter"=>'s',
        "Datos"=>'s02',
        "necessary"=> true, 
        "modified"=> false,  
    ];

    $meta3['Region'] = [
        "name"=> 'Región',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>"",
        "1"=>"Región de Arica y Parinacota",
        "2"=>"Región de Tarapacá",
        "3"=>"Región de Antofagasta",
        "4"=>"Región de Atacama",
        "5"=>"Región de Coquimbo", 
        "6"=>"Región de Valparaíso",
        "7"=>"Región del Libertador General Bernardo O'Higgins",
        "8"=>"Región del Maule",
        "9"=>"Región del Biobío",
        "10"=>"Región de La Araucanía",
        "11"=>"Región de Los Ríos",
        "12"=>"Región de Los Lagos",
        "13"=>"Región Aysén del General Carlos Ibáñez del Campo",
        "14"=>"Región de Magallanes y de la Antártica Chilena",
        "27"=>"Región de Ñuble",
        ],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Comuna'] = [
        "name"=> 'Comuna',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>""],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
    ];
    $meta3['Ciudad'] = [
        "name"=> 'Ciudad',
        "value"=> "",     
        "disabled"=> false,      
        "primary"=>false,
        "date"=>'',
        "option"=> [""=>""],
        "filter"=>'',
        "Datos"=>'',
        "necessary"=> true, 
        "modified"=> false,  
    ];

    $Total = $this->total();
    $meta2["Total"] = $Total[0]->Total;
    $Total["Select"]= $meta3;
    

return  $Total;

} 

}
